<?php

namespace App\Http\Controllers;

use App\Services\BatchService;
use App\Traits\HasNotifications;
use Illuminate\Http\Request;

class BatchController extends Controller
{
    use HasNotifications;

    protected $batchService;

    public function __construct(BatchService $batchService)
    {
        $this->batchService = $batchService;
    }

    public function index()
    {
        return view('batches.index');
    }

    public function create()
    {
        return view('batches.create');
    }

    public function edit($id)
    {
        return view('batches.edit', compact('id'));
    }

    public function assignStudents()
    {
        return view('batches.assign-students');
    }
}
