<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\PaymentService;
use App\Traits\HasNotifications;

class PaymentRequestController extends Controller
{
    use HasNotifications;

    protected $paymentService;

    public function __construct(PaymentService $paymentService)
    {
        $this->paymentService = $paymentService;
    }

    public function index()
    {
        return view('payment-requests.index');
    }

    public function create()
    {
        return view('payment-requests.create');
    }

    public function viewByTarget()
    {
        return view('payment-requests.view-by-target');
    }

    public function paymentsHistory()
    {
        return view('payments.history');
    }

    public function createPayment()
    {
        return view('payments.create');
    }

    public function viewPayment(\App\Models\Payment $payment)
    {
        $payment->load(['paymentRequest', 'user']);
        return view('payments.view', compact('payment'));
    }
}
