<?php

namespace App\Http\Controllers;

use App\Services\PromotionService;
use App\Traits\HasNotifications;
use Illuminate\Http\Request;

class PromotionController extends Controller
{
    use HasNotifications;
    
    protected $promotionService;
    
    public function __construct(PromotionService $promotionService)
    {
        $this->promotionService = $promotionService;
    }
    
    public function index()
    {
        return view('promotion.index');
    }
    
    public function byClass()
    {
        return view('promotion.by-class');
    }
    
    public function byBatch()
    {
        return view('promotion.by-batch');
    }
    
    public function individual()
    {
        return view('promotion.individual');
    }
}