<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Traits\HasNotifications;
use Illuminate\Http\Request;

class StaffController extends Controller
{
    use HasNotifications;

    public function index()
    {
        return view('staff.index');
    }

    public function create()
    {
        return view('staff.create');
    }

    public function edit($username)
    {
        $staff = User::where('username', $username)->firstOrFail();
        return view('staff.edit', ['id' => $staff->id]);
    }

    public function show($username)
    {
        $staff = User::where('username', $username)->firstOrFail();
        return view('staff.show', ['username' => $username]);
    }

    public function assignClasses()
    {
        return view('staff.assign-classes');
    }
}
