<?php

namespace App\Http\Controllers\Student;

use App\Http\Controllers\Controller;
use App\Traits\HasNotifications;
use App\Models\SchoolSession;

class StudentDashboardController extends Controller
{
    use HasNotifications;

    public function index()
    {
        $student = auth()->user();
        $currentSession = SchoolSession::active()->first();
        
        return view('student.dashboard', compact('student', 'currentSession'));
    }
}