<?php

namespace App\Http\Controllers\Student;

use App\Http\Controllers\Controller;
use App\Traits\HasNotifications;
use App\Services\PaymentService;

class StudentPaymentController extends Controller
{
    use HasNotifications;

    protected $paymentService;

    public function __construct(PaymentService $paymentService)
    {
        $this->paymentService = $paymentService;
    }

    public function index()
    {
        return view('student.payments.index');
    }

    public function makePayment($paymentRequestId)
    {
        return view('student.payments.make-payment', compact('paymentRequestId'));
    }
    
    public function viewReceipt($paymentId)
    {
        $payment = \App\Models\Payment::where('payment_id', $paymentId)
            ->where('user_id', auth()->id())
            ->where('status', 'successful')
            ->with(['paymentRequest', 'user', 'recordedBy'])
            ->firstOrFail();
            
        $schoolInfo = [
            'name' => settings('school_name', config('app.name')),
            'address' => settings('school_address', ''),
            'website' => settings('school_website', ''),
            'email' => settings('school_email', ''),
            'phone' => settings('school_phone', '')
        ];
        
        // Generate QR Code
        $qrData = [
            'Student Name' => $payment->user->name,
            'Student ID' => $payment->user->student_id ?? $payment->user->username,
            'Payment ID' => $payment->payment_id,
            'Confirmed By' => $payment->recordedBy->name ?? 'System',
            'Payment Date' => $payment->updated_at->format('M d, Y g:i A'),
            'Generated' => now()->format('M d, Y g:i A')
        ];
        
        $qrString = collect($qrData)->map(fn($value, $key) => "$key: $value")->implode("\n");
        $qrCode = \SimpleSoftwareIO\QrCode\Facades\QrCode::size(150)->generate($qrString);
            
        return view('student.payments.receipt', compact('payment', 'schoolInfo', 'qrCode'));
    }
    
    public function printReceipt($paymentId)
    {
        $payment = \App\Models\Payment::where('payment_id', $paymentId)
            ->where('user_id', auth()->id())
            ->where('status', 'successful')
            ->with(['paymentRequest', 'user', 'recordedBy'])
            ->firstOrFail();
            
        $schoolInfo = [
            'name' => settings('school_name', config('app.name')),
            'address' => settings('school_address', ''),
            'website' => settings('school_website', ''),
            'email' => settings('school_email', ''),
            'phone' => settings('school_phone', '')
        ];
        
        // Generate QR Code
        $qrData = [
            'Student Name' => $payment->user->name,
            'Student ID' => $payment->user->student_id ?? $payment->user->username,
            'Payment ID' => $payment->payment_id,
            'Confirmed By' => $payment->recordedBy->name ?? 'System',
            'Payment Date' => $payment->updated_at->format('M d, Y g:i A'),
            'Generated' => now()->format('M d, Y g:i A')
        ];
        
        $qrString = collect($qrData)->map(fn($value, $key) => "$key: $value")->implode("\n");
        $qrCode = \SimpleSoftwareIO\QrCode\Facades\QrCode::size(150)->generate($qrString);
            
        return view('student.payments.receipt-print', compact('payment', 'schoolInfo', 'qrCode'));
    }
}