<?php

namespace App\Http\Controllers;

use App\Services\StudentService;
use App\Traits\HasNotifications;

class StudentController extends Controller
{
    use HasNotifications;

    protected $studentService;

    public function __construct(StudentService $studentService)
    {
        $this->studentService = $studentService;
    }

    public function index()
    {
        return view('students.index');
    }

    public function create()
    {
        return view('students.create');
    }

    public function edit($student_id)
    {
        return view('students.edit', compact('student_id'));
    }

    public function show($student_id)
    {
        return view('students.show', compact('student_id'));
    }
}