<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Services\SubjectService;
use App\Traits\HasNotifications;
use Illuminate\Http\Request;

class SubjectController extends Controller
{
    use HasNotifications;

    protected $subjectService;

    public function __construct(SubjectService $subjectService)
    {
        $this->subjectService = $subjectService;
    }

    public function index()
    {
        return view('subjects.index');
    }

    public function create()
    {
        return view('subjects.create');
    }

    public function assignClasses()
    {
        return view('subjects.assign-classes');
    }
}
