<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Models\Setting;

class CheckSalaryView
{
    public function handle(Request $request, Closure $next)
    {
        $setting = Setting::where('key', 'allow_staff_salary_view')->first();
        $allowView = $setting ? (bool) $setting->value : true;

        if (!$allowView && !auth()->user()->can('manage-payments')) {
            abort(403, 'Access to salary history is currently disabled.');
        }

        return $next($request);
    }
}