<?php

namespace App\Livewire;

use App\Services\SubjectService;
use App\Traits\HasNotifications;
use Livewire\Component;

class CreateSubjectForm extends Component
{
    use HasNotifications;

    public $name = '';

    protected $subjectService;

    public function boot(SubjectService $subjectService)
    {
        $this->subjectService = $subjectService;
    }

    public function rules()
    {
        return [
            'name' => 'required|string|max:255|unique:subjects,name'
        ];
    }

    public function create()
    {
        $this->validate();
        
        $this->subjectService->createSubject(['name' => $this->name]);
        
        $this->reset('name');
        $this->showToast('success', 'Subject created successfully!');
        $this->dispatch('subjectCreated');
        $this->dispatch('close-modal');
    }

    public function render()
    {
        return view('livewire.create-subject-form');
    }
}