<?php

namespace App\Livewire;

use Livewire\Component;
use Livewire\WithPagination;
use App\Models\Payment;
use App\Traits\HasNotifications;

class PaymentsTable extends Component
{
    use WithPagination, HasNotifications;

    public $search = '';
    public $statusFilter = '';
    public $perPage = 10;

    protected $paginationTheme = 'bootstrap';

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function updatingStatusFilter()
    {
        $this->resetPage();
    }

    public function render()
    {
        $payments = Payment::with(['paymentRequest', 'user', 'recordedBy'])
            ->when($this->search, function ($q) {
                $q->whereHas('paymentRequest', function($pr) {
                    $pr->where('title', 'like', '%' . $this->search . '%');
                })
                ->orWhereHas('user', function($u) {
                    $u->where('firstname', 'like', '%' . $this->search . '%')
                      ->orWhere('surname', 'like', '%' . $this->search . '%');
                });
            })
            ->when($this->statusFilter, function ($q) {
                $q->where('status', $this->statusFilter);
            })
            ->orderBy('created_at', 'desc')
            ->paginate($this->perPage);

        return view('livewire.payments-table', compact('payments'));
    }
}
