<?php

namespace App\Livewire\SchoolClass;

use App\Models\SchoolClass;
use App\Traits\HasNotifications;
use Livewire\Component;

class SchoolClassReorder extends Component
{
    use HasNotifications;

    public $classes = [];

    public function mount()
    {
        $this->loadClasses();
    }

    public function loadClasses()
    {
        $this->classes = SchoolClass::orderBy('order')->get()->toArray();
    }

    public function updateOrder($orderedIds)
    {
        foreach ($orderedIds as $index => $id) {
            SchoolClass::where('id', $id)->update(['order' => $index + 1]);
        }

        $this->loadClasses();
        
        session()->flash('toast', ['type' => 'success', 'message' => 'Class order updated successfully!']);
    }

    public function render()
    {
        return view('livewire.school-class.school-class-reorder');
    }
}
