<?php

namespace App\Livewire\Settings;

use App\Models\Setting;
use App\Traits\HasNotifications;
use Livewire\Component;

class AnnualPassPercentage extends Component
{
    use HasNotifications;

    public $percentage;

    public function mount()
    {
        $this->percentage = settings('annual_pass_percentage', 50);
    }

    public function save()
    {
        $this->validate([
            'percentage' => 'required|numeric|min:0|max:100'
        ]);

        try {
            Setting::set('annual_pass_percentage', $this->percentage);
            $this->showToast('success', 'Annual pass percentage updated successfully!', 'Settings Updated');
        } catch (\Exception $e) {
            $this->showToast('error', 'Error: ' . $e->getMessage(), 'Settings Error');
        }
    }

    public function render()
    {
        return view('livewire.settings.annual-pass-percentage');
    }
}