<?php

namespace App\Livewire\Settings;

use Livewire\Component;
use App\Models\Setting;
use App\Traits\HasNotifications;

class FinanceSettings extends Component
{
    use HasNotifications;

    public $accounts = [];
    public $allowStaffSalaryView = true;

    public function mount()
    {
        $this->loadAccounts();
    }

    public function loadAccounts()
    {
        $accountsData = Setting::where('key', 'school_accounts')->first();
        $this->accounts = $accountsData ? json_decode($accountsData->value, true) : [
            ['account_number' => '', 'account_name' => '', 'bank_name' => '', 'currency' => 'NGN'],
            ['account_number' => '', 'account_name' => '', 'bank_name' => '', 'currency' => 'NGN'],
            ['account_number' => '', 'account_name' => '', 'bank_name' => '', 'currency' => 'NGN'],
        ];
        
        $salaryViewSetting = Setting::where('key', 'allow_staff_salary_view')->first();
        $this->allowStaffSalaryView = $salaryViewSetting ? (bool) $salaryViewSetting->value : true;
    }

    public function save()
    {
        $this->validate([
            'accounts.*.account_number' => 'nullable|string|max:20',
            'accounts.*.account_name' => 'nullable|string|max:255',
            'accounts.*.bank_name' => 'nullable|string|max:255',
            'accounts.*.currency' => 'required|string|size:3',
        ]);

        try {
            Setting::updateOrCreate(
                ['key' => 'school_accounts'],
                ['value' => json_encode($this->accounts)]
            );
            
            Setting::updateOrCreate(
                ['key' => 'allow_staff_salary_view'],
                ['value' => $this->allowStaffSalaryView]
            );

            $this->showToast('success', 'Finance settings saved successfully!', 'Settings Updated');
        } catch (\Exception $e) {
            $this->showToast('error', 'Error: ' . $e->getMessage(), 'Settings Error');
        }
    }

    public function render()
    {
        return view('livewire.settings.finance-settings');
    }
}
