<?php

namespace App\Livewire\Settings;

use Livewire\Component;
use App\Traits\HasNotifications;
use App\Models\Setting;

class SchoolInfoForm extends Component
{
    use HasNotifications;

    public $school_name = '';
    public $school_address = '';
    public $contact_phone_1 = '';
    public $contact_phone_2 = '';
    public $school_website = '';
    public $school_email = '';

    public function mount()
    {
        $this->school_name = Setting::get('school_name', '');
        $this->school_address = Setting::get('school_address', '');
        $this->contact_phone_1 = Setting::get('contact_phone_1', '');
        $this->contact_phone_2 = Setting::get('contact_phone_2', '');
        $this->school_website = Setting::get('school_website', '');
        $this->school_email = Setting::get('school_email', '');
    }

    public function save()
    {
        $this->validate([
            'school_name' => 'required|string|max:255',
            'school_address' => 'required|string|max:500',
            'contact_phone_1' => 'required|string|max:20',
            'contact_phone_2' => 'nullable|string|max:20',
            'school_website' => 'nullable|string|max:255',
            'school_email' => 'required|email|max:255',
        ]);

        Setting::set('school_name', $this->school_name);
        Setting::set('school_address', $this->school_address);
        Setting::set('contact_phone_1', $this->contact_phone_1);
        Setting::set('contact_phone_2', $this->contact_phone_2);
        Setting::set('school_website', $this->school_website);
        Setting::set('school_email', $this->school_email);

        session()->flash('toast', [
            'type' => 'success',
            'message' => 'School information updated successfully!'
        ]);

        return redirect()->route('settings.school-info');
    }

    public function render()
    {
        return view('livewire.settings.school-info-form');
    }
}