<?php

namespace App\Livewire\Student;

use Livewire\Component;
use App\Traits\HasNotifications;
use App\Models\SchoolSession;
use App\Services\ViewResultsService;
use App\Services\QrCodeService;

class StudentTermlyResults extends Component
{
    use HasNotifications;

    public $showModal = false;
    public $resultData = null;
    public $qrCode = null;

    public function viewResult($sessionId)
    {
        $student = auth()->user();
        $session = SchoolSession::findOrFail($sessionId);
        
        $viewResultsService = new ViewResultsService();
        $this->resultData = $viewResultsService->getStudentCompleteResult($student->id, $session->id);
        
        if ($this->resultData && $this->resultData['approval']) {
            $qrCodeService = new QrCodeService();
            $currentUrl = request()->url();
            $this->qrCode = $qrCodeService->generateResultQrCode(
                $this->resultData['student'], 
                $this->resultData['approval'], 
                $this->resultData['session'], 
                $currentUrl
            );
        }
        
        $this->showModal = true;
    }

    public function closeModal()
    {
        $this->showModal = false;
        $this->resultData = null;
        $this->qrCode = null;
    }

    public function render()
    {
        $student = auth()->user();
        $sessions = SchoolSession::whereHas('resultApprovals', function($query) use ($student) {
            $query->where('student_id', $student->id);
        })->orderBy('created_at', 'desc')->get();

        return view('livewire.student.student-termly-results', compact('sessions'));
    }
}