<?php

namespace App\Livewire;

use App\Models\User;
use App\Models\Country;
use App\Models\State;
use App\Models\City;
use Livewire\Component;

class StudentProfile extends Component
{
    public $studentId;
    public $student;

    public function mount($studentId)
    {
        $this->studentId = $studentId;
        $this->student = User::with(['batch', 'country', 'state', 'city'])
            ->whereDoesntHave('roles')
            ->where('student_id', $studentId)
            ->firstOrFail();
    }

    public function render()
    {
        return view('livewire.student-profile');
    }
}