<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Casts\Attribute;

class Batch extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'name',
        'school_class_id',
        'description',
        'is_active',
        'graduated',
        'graduated_at',
        'capacity',
        'current_students'
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'graduated' => 'boolean',
        'capacity' => 'integer',
        'current_students' => 'integer'
    ];

    protected function name(): Attribute
    {
        return Attribute::make(
            get: fn ($value) => $this->graduated ? $value . ' (Graduated ' . $this->graduated_at . ')' : $value,
        );
    }

    public function schoolClass()
    {
        return $this->belongsTo(SchoolClass::class);
    }

    public function students()
    {
        return $this->hasMany(User::class, 'batch_id');
    }
}
