<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SubjectAlias extends Model
{
    use SoftDeletes;

    protected $fillable = ['subject_id', 'school_class_id', 'alias'];

    public function subject()
    {
        return $this->belongsTo(Subject::class);
    }

    public function schoolClass()
    {
        return $this->belongsTo(SchoolClass::class);
    }

    public function getAliasAttribute($value)
    {
        return $value && str_contains($value, '.') ? strtoupper($value) : ucwords(strtolower($value));
    }
}
