<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Wallet extends Model
{
    protected $fillable = [
        'currency',
        'total_credit',
        'total_debit',
        'balance',
        'meta',
    ];

    protected $casts = [
        'meta' => 'array',
    ];

    // Convert from cents to decimal for display
    public function getTotalCreditAttribute($value)
    {
        return $value / 100;
    }

    public function getTotalDebitAttribute($value)
    {
        return $value / 100;
    }

    public function getBalanceAttribute($value)
    {
        return $value / 100;
    }

    // Convert from decimal to cents for storage
    public function setTotalCreditAttribute($value)
    {
        $this->attributes['total_credit'] = $value * 100;
    }

    public function setTotalDebitAttribute($value)
    {
        $this->attributes['total_debit'] = $value * 100;
    }

    public function setBalanceAttribute($value)
    {
        $this->attributes['balance'] = $value * 100;
    }

    public static function creditWallet($currency, $amount)
    {
        $wallet = static::firstOrCreate(['currency' => $currency]);
        
        $wallet->increment('total_credit', $amount * 100);
        $wallet->increment('balance', $amount * 100);
        
        return $wallet;
    }

    public static function debitWallet($currency, $amount)
    {
        $wallet = static::firstOrCreate(['currency' => $currency]);
        
        $wallet->increment('total_debit', $amount * 100);
        $wallet->decrement('balance', $amount * 100);
        
        return $wallet;
    }
}