<?php

namespace App\Services;

use App\Models\SchoolSession;
use Illuminate\Database\Eloquent\Collection;

class SchoolSessionService
{
    public function getAllSessions(): Collection
    {
        return SchoolSession::orderBy('start_year', 'desc')->get();
    }

    public function getActiveSession(): ?SchoolSession
    {
        return SchoolSession::active()->first();
    }

    public function createSession(array $data): SchoolSession
    {
        if ($data['is_active'] ?? false) {
            $this->deactivateAllSessions();
        }

        return SchoolSession::create($data);
    }

    public function updateSession(SchoolSession $session, array $data): SchoolSession
    {
        if ($data['is_active'] ?? false) {
            $this->deactivateAllSessions();
        }

        $session->update($data);
        return $session->fresh();
    }

    public function deleteSession(SchoolSession $session): bool
    {
        return $session->delete();
    }

    public function activateSession(SchoolSession $session): SchoolSession
    {
        $this->deactivateAllSessions();
        $session->update(['is_active' => true]);
        return $session->fresh();
    }

    private function deactivateAllSessions(): void
    {
        SchoolSession::where('is_active', true)->update(['is_active' => false]);
    }
}