<?php

namespace App\Traits;

trait HasNotifications
{
    public function confirmAction($title = 'Are you sure?', $text = 'This action cannot be undone!', $confirmText = 'Yes, proceed!', $cancelText = 'Cancel')
    {
        $this->dispatch('confirm-action', [
            'title' => $title,
            'text' => $text,
            'confirmText' => $confirmText,
            'cancelText' => $cancelText
        ]);
    }

    public function showToast($type = 'success', $message = '', $title = '', $icon = null)
    {
        $this->dispatch('show-toast', [
            'type' => $type,
            'message' => $message,
            'title' => $title,
            'icon' => $icon ?? $type
        ]);
    }

    public function showError($message, $title = 'Error')
    {
        $this->showToast('error', $message, $title);
    }

    public function showSuccess($message, $title = 'Success')
    {
        $this->showToast('success', $message, $title);
    }

    public function showWarning($message, $title = 'Warning')
    {
        $this->showToast('warning', $message, $title);
    }

    public function showInfo($message, $title = 'Info')
    {
        $this->showToast('info', $message, $title);
    }
}