<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->decimal('monthly_salary', 10, 2)->nullable();
            $table->string('bank_name')->nullable();
            $table->string('account_number')->nullable();
            $table->string('account_name')->nullable();
            $table->string('tax_id')->nullable();
            $table->integer('payment_day')->nullable()->default(31);
            $table->json('meta')->nullable();
        });
    }

    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                'monthly_salary',
                'bank_name',
                'account_number',
                'account_name',
                'tax_id',
                'payment_day',
                'meta'
            ]);
        });
    }
};