<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('salary_histories', function (Blueprint $table) {
            $table->dropColumn(['bonus', 'deductions', 'bonus_reason', 'deduction_reason']);
        });
    }

    public function down()
    {
        Schema::table('salary_histories', function (Blueprint $table) {
            $table->decimal('bonus', 10, 2)->default(0);
            $table->decimal('deductions', 10, 2)->default(0);
            $table->text('bonus_reason')->nullable();
            $table->text('deduction_reason')->nullable();
        });
    }
};