<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('school_sessions', function (Blueprint $table) {
            $table->integer('ca_max_score')->default(40)->after('description');
            $table->integer('exam_max_score')->default(60)->after('ca_max_score');
            $table->integer('ca_pass_mark')->default(20)->after('exam_max_score');
            $table->integer('exam_pass_mark')->default(30)->after('ca_pass_mark');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('school_sessions', function (Blueprint $table) {
            $table->dropColumn(['ca_max_score', 'exam_max_score', 'ca_pass_mark', 'exam_pass_mark']);
        });
    }
};
