<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('result_approvals', function (Blueprint $table) {
            $table->id();
            $table->foreignId('student_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('session_id')->constrained('school_sessions')->onDelete('cascade');
            
            // Affective Traits
            $table->decimal('punctuality', 2, 1)->default(4.0);
            $table->decimal('mental_alertness', 2, 1)->default(4.0);
            $table->decimal('attentiveness', 2, 1)->default(4.0);
            $table->decimal('respect', 2, 1)->default(4.0);
            $table->decimal('neatness', 2, 1)->default(4.0);
            $table->decimal('politeness', 2, 1)->default(4.0);
            $table->decimal('honesty', 2, 1)->default(4.0);
            $table->decimal('relationship_with_peers', 2, 1)->default(4.0);
            $table->decimal('attitude_to_school', 2, 1)->default(4.0);
            $table->decimal('teamwork', 2, 1)->default(4.0);
            $table->decimal('completes_school_work_promptly', 2, 1)->default(4.0);
            
            // Psychomotor Skills
            $table->decimal('reading', 2, 1)->default(4.0);
            $table->decimal('verbal_fluency_diction', 2, 1)->default(4.0);
            $table->decimal('handwriting', 2, 1)->default(4.0);
            $table->decimal('musical_skills', 2, 1)->default(4.0);
            $table->decimal('creative_arts', 2, 1)->default(4.0);
            $table->decimal('physical_education', 2, 1)->default(4.0);
            $table->decimal('general_reasoning', 2, 1)->default(4.0);
            
            $table->text('principal_remarks')->default('Impressive result, keep it up!');
            $table->foreignId('approved_by')->constrained('users')->onDelete('cascade');
            $table->softDeletes();
            $table->timestamps();
            
            $table->unique(['student_id', 'session_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('result_approvals');
    }
};
