<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('wallets', function (Blueprint $table) {
            $table->id();
            $table->string('currency', 3);
            $table->bigInteger('total_credit')->default(0); // stored as cents
            $table->bigInteger('total_debit')->default(0); // stored as cents
            $table->bigInteger('balance')->default(0); // stored as cents
            $table->json('meta')->nullable();
            $table->timestamps();
            
            $table->unique('currency');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('wallets');
    }
};