<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('result_approvals', function (Blueprint $table) {
            $table->json('subjects_snapshot')->nullable()->after('approved_by')->comment('Snapshot of subjects and aliases at approval time');
            $table->decimal('annual_pass_percentage', 5, 2)->nullable()->after('subjects_snapshot')->comment('Annual pass percentage at approval time');
            $table->json('approval_log')->nullable()->after('annual_pass_percentage')->comment('Log of approval/disapproval actions');
        });
    }

    public function down(): void
    {
        Schema::table('result_approvals', function (Blueprint $table) {
            $table->dropColumn(['subjects_snapshot', 'annual_pass_percentage', 'approval_log']);
        });
    }
};