<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Result;
use Carbon\Carbon;

class ResultsSeeder extends Seeder
{
    public function run()
    {
        $csvFile = base_path('results.csv');
        
        if (!file_exists($csvFile)) {
            $this->command->error('CSV file not found at: ' . $csvFile);
            return;
        }

        $file = fopen($csvFile, 'r');
        fgetcsv($file); // Skip header
        
        $count = 0;
        $skipped = 0;

        while (($row = fgetcsv($file)) !== false) {
            if (empty($row[1]) || $row[1] === 'NULL') {
                $skipped++;
                continue;
            }

            $exists = Result::where('student_id', $row[1])
                ->where('session_id', $row[2])
                ->where('subject_id', $row[3])
                ->exists();

            if (!$exists) {
                Result::create([
                    'student_id' => $row[1],
                    'session_id' => $row[2],
                    'subject_id' => $row[3],
                    'ca_score' => $row[4],
                    'exam_score' => $row[5],
                    'ca_absent' => $row[6],
                    'exam_absent' => $row[7],
                    'approved' => $row[9],
                    'approved_at' => $row[10] === 'NULL' ? null : $row[10],
                    'approved_by' => $row[11] === 'NULL' ? null : $row[11],
                    'created_at' => $row[13] === 'NULL' ? Carbon::now() : $row[13],
                    'updated_at' => $row[14] === 'NULL' ? Carbon::now() : $row[14],
                ]);
                $count++;
            } else {
                $skipped++;
            }

            if (($count + $skipped) % 500 === 0) {
                $this->command->info("Processed " . ($count + $skipped) . " records (Inserted: {$count}, Skipped: {$skipped})...");
            }
        }

        fclose($file);
        $this->command->info("Migration complete! Inserted: {$count}, Skipped: {$skipped}");
    }
}
