@extends('layouts.school-portal')

@section('title', 'Dashboard')

@section('content')
    <div class="container-fluid py-4">
        <div class="row">
            <div class="col-12">
                <div class="welcome-card dashboard-welcome">
                    <h1 class="welcome-title text-light">Welcome Back!</h1>
                    <p class="welcome-subtitle text-light">{{ auth()->user()->name ?? 'User' }}</p>
                    @if($assigned_classes->count() > 0)
                        <div class="mt-3 text-center">
                            <div class="d-flex flex-wrap gap-2 justify-content-center">
                                @foreach($assigned_classes as $class)
                                    <span class="badge bg-light text-dark px-3 py-2">{{ $class->alias ?: $class->name }}</span>
                                @endforeach
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Announcements -->
        <livewire:dashboard-announcements />

        <!-- Main Stats Cards -->
        <div class="row g-4 mt-3">
            @if(auth()->user()->isAdmin() || auth()->user()->isHeadTeacher())
                <div class="col-md-6 col-lg-3">
                    <div class="dashboard-card">
                        <div class="card-icon sessions">
                            <i class="fas fa-calendar-alt"></i>
                        </div>
                        <div class="card-content">
                            <h3>Current Session</h3>
                            <p class="card-number" style="font-size: 1.2rem; line-height: 1.3;">
                                @if($current_session)
                                    {{ $current_session->name }}<br>
                                    <small style="font-size: 0.9rem; opacity: 0.8;">{{ $current_session->start_year }}
                                        /{{ $current_session->end_year }}</small>
                                @else
                                    None
                                @endif
                            </p>
                        </div>
                    </div>
                </div>
            @endif
            @if(auth()->user()->isTeacher())
                <div class="col-md-6 col-lg-3">
                    <div class="dashboard-card">
                        <div class="card-icon student">
                            <i class="fas fa-user-graduate"></i>
                        </div>
                        <div class="card-content">
                            <h3>My Students</h3>
                            <p class="card-number">{{ number_format($students_count) }}</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-3">
                    <div class="dashboard-card">
                        <div class="card-icon classes">
                            <i class="fas fa-school"></i>
                        </div>
                        <div class="card-content">
                            <h3>My Classes</h3>
                            <p class="card-number">{{ number_format($classes_count) }}</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-3">
                    <div class="dashboard-card">
                        <div class="card-icon teacher">
                            <i class="fas fa-book"></i>
                        </div>
                        <div class="card-content">
                            <h3>Subjects</h3>
                            <p class="card-number">{{ number_format($teacher_subjects) }}</p>
                        </div>
                    </div>
                </div>
            @elseif(auth()->user()->isAdmin() || auth()->user()->isHeadTeacher() || auth()->user()->isBursar())
                <div class="col-md-6 col-lg-3">
                    <div class="dashboard-card">
                        <div class="card-icon student">
                            <i class="fas fa-user-graduate"></i>
                        </div>
                        <div class="card-content">
                            <h3>Students</h3>
                            <p class="card-number">{{ number_format($students_count) }}</p>
                        </div>
                    </div>
                </div>
            @endif

            @if(auth()->user()->isAdmin() || auth()->user()->isHeadTeacher())
                <div class="col-md-6 col-lg-3">
                    <div class="dashboard-card">
                        <div class="card-icon teacher">
                            <i class="fas fa-users"></i>
                        </div>
                        <div class="card-content">
                            <h3>Staff</h3>
                            <p class="card-number">{{ number_format($staff_count) }}</p>
                        </div>
                    </div>
                </div>
            @endif

            @if(auth()->user()->isAdmin() || auth()->user()->isHeadTeacher() || auth()->user()->isBursar())
            <div class="col-md-6 col-lg-3">
                <div class="dashboard-card">
                    <div class="card-icon classes">
                        <i class="fas fa-school"></i>
                    </div>
                    <div class="card-content">
                        <h3>Classes</h3>
                        <p class="card-number">{{ number_format($classes_count) }}</p>
                    </div>
                </div>
            </div>
            @endif

            @can('manage-payments')
                <div class="col-md-6 col-lg-3">
                    <div class="dashboard-card">
                        <div class="card-icon payments">
                            <i class="fas fa-money-bill-wave"></i>
                        </div>
                        <div class="card-content">
                            <h3>{{ auth()->user()->isStudent() ? 'Wallet Balance' : 'Total Wallet Balance' }}</h3>
                            <p class="card-number">₦{{ number_format($wallet_balance, 0) }}</p>
                        </div>
                    </div>
                </div>
            @endcan
        </div>

        @if(auth()->user()->isTeacher())
            <div class="row mt-4">
                <div class="col-lg-8">
                    <!-- Additional content can go here -->
                </div>
                <div class="col-lg-4">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title mb-0">Quick Actions</h4>
                        </div>
                        <div class="card-body">
                            <div class="d-grid gap-2">
                                <a href="{{ route('results.by-subject') }}" class="btn btn-primary">
                                    <i class="fas fa-edit me-2"></i>Enter Results
                                </a>
                                <a href="{{ route('results.view-results') }}" class="btn btn-info">
                                    <i class="fas fa-eye me-2"></i>View Results
                                </a>
                                <a href="{{ route('results.offline-upload') }}" class="btn btn-success">
                                    <i class="fas fa-file-excel me-2"></i>Upload Results
                                </a>
                                <a href="{{ route('staff.profile') }}" class="btn btn-secondary">
                                    <i class="fas fa-user me-2"></i>My Profile</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif

    </div>
@endsection
