@extends('layouts.guest')
@section('content')
    <div class="welcome-container">

        <div class="welcome-card col-11 col-md-10 col-lg-6">
            <div class="mb-4">
                <img src="{{ asset('images/rosa-mys-logo.png') }}" alt="School Logo" class="img-fluid mb-3"
                     style="max-width: 120px;">
            </div>

            @auth
                <h1 class="welcome-title text-dark">Welcome Back, {{ auth()->user()->name }}!</h1>
                <p class="welcome-subtitle">You are already logged in</p>

                <div class="account-types">
                    <a href="{{ route('dashboard') }}" class="account-type-btn admin">
                        <i class="fas fa-tachometer-alt me-2"></i>
                        Dashboard
                    </a>

                    <a href="{{ route('logout') }}" class="account-type-btn student">
                        <i class="fas fa-sign-out-alt me-2"></i>
                        Logout
                    </a>
                </div>
            @else
                <h1 class="welcome-title text-dark">Welcome to Our School!</h1>
                <p class="welcome-subtitle">Choose your account type to get started</p>

                <div class="account-types">
                    <button class="account-type-btn student" data-type="student">
                        <i class="fas fa-user-graduate me-2"></i>
                        Student
                    </button>

                    <button class="account-type-btn admin" data-type="admin">
                        <i class="fas fa-user-shield me-2"></i>
                        Admin
                    </button>
                </div>
            @endauth
        </div>
    </div>
@endsection

@guest
    @section('modals')
        <!-- Login Modal -->
        <div class="modal fade" id="loginModal" tabindex="-1" aria-labelledby="loginModalLabel" aria-hidden="true"
             data-bs-backdrop="static" data-bs-keyboard="false">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <livewire:login-form/>
                    </div>
                </div>
            </div>
        </div>
    @endsection
@endguest
