<!DOCTYPE html>
<html lang="en">

<head>
    <!-- Required meta tags-->
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Rosa Mystica Portal">
    <meta name="author" content="Rosa Mystica">
    <link rel="icon" href="{{ asset('images/rosa-mys-logo.png') }}" type="image/x-icon">

    <title>Welcome - {{ config('app.name') }}</title>

    <!-- Bootstrap CSS-->
    <link href="{{ asset('vendor/bootstrap-5.3.7.min.css') }}" rel="stylesheet" media="all">
    <link href="{{ asset('vendor/fontawesome-6.7.2/css/all.min.css') }}" rel="stylesheet" media="all">

    <!-- Main CSS-->
    <link href="{{ asset('css/school-portal.css') }}" rel="stylesheet" media="all">
    <style>
        footer {
            left: 0 !important;
            width: 100% !important;
        }
    </style>
</head>

<body class="homepage">

<x-header/>

<div class="container-fluid">
    <div class="page-content">
        @yield('content')
    </div>
</div>
<x-footer/>
@yield('modals')

<!-- Livewire Loading Animation -->
<div id="livewire-loader" class="livewire-loader" style="display: none;">
    <div class="loader-dots">
        <div class="dot"></div>
        <div class="dot"></div>
        <div class="dot"></div>
    </div>
</div>

<!-- JS-->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="{{ asset('vendor/bootstrap-5.3.7.bundle.min.js') }}"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="{{ asset('js/school-portal.js') }}"></script>

@if(session('toast'))
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const toastData = @json(session('toast'));
            showToast(toastData.type, toastData.message, toastData.title, toastData.icon);
        });
    </script>
@endif

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const loader = document.getElementById('livewire-loader');
        let activeRequests = 0;
        let safetyTimeout;

        function showLoader() {
            activeRequests++;
            loader.style.display = 'flex';

            // Safety timeout - hide after 10 seconds max
            clearTimeout(safetyTimeout);
            safetyTimeout = setTimeout(() => {
                activeRequests = 0;
                loader.style.display = 'none';
            }, 10000);
        }

        function hideLoader() {
            activeRequests--;
            if (activeRequests <= 0) {
                activeRequests = 0;
                clearTimeout(safetyTimeout);
                loader.style.display = 'none';
            }
        }

        document.addEventListener('livewire:init', () => {
            Livewire.hook('request', showLoader);
            Livewire.hook('response', hideLoader);
            Livewire.hook('commit', hideLoader);
            Livewire.hook('morph.updated', hideLoader);
        });
    });
</script>
</body>

</html>
<!-- end document-->
