<!DOCTYPE html>
<html lang="en">

<head>
    <!-- Required meta tags-->
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Rosa Mystica Portal">
    <meta name="author" content="Rosa Mystica">
    <link rel="icon" href="{{ asset('images/rosa-mys-logo.png') }}" type="image/x-icon">

    <title>@yield('title', 'Dashboard') - {{ config('app.name') }}</title>

    <!-- Bootstrap CSS-->
    <link href="{{ asset('vendor/bootstrap-5.3.7.min.css') }}" rel="stylesheet" media="all">
    <link href="{{ asset('vendor/fontawesome-6.7.2/css/all.min.css') }}" rel="stylesheet" media="all">

    <!-- Main CSS-->
    <link href="{{ asset('css/school-portal.css') }}" rel="stylesheet" media="all">

    @stack('styles')
</head>

<body class="dashboard-body">

<x-header/>
@if(auth()->user()->isStudent())
    <x-student-sidebar/>
@else
    <x-sidebar/>
@endif

<!-- Sidebar Toggle Arrow -->
<button class="sidebar-toggle-arrow" id="sidebarToggle">
    <i class="fas fa-chevron-right"></i>
    <span class="sidebar-text">sidebar</span>
</button>

<div class="page-wrapper">
    <div class="page-content">
        @yield('content')
    </div>
</div>
<x-footer/>

@yield('modals')

<!-- Livewire Loading Animation -->
<div id="livewire-loader" class="livewire-loader" style="display: none;">
    <div class="loader-dots">
        <div class="dot"></div>
        <div class="dot"></div>
        <div class="dot"></div>
    </div>
</div>

<!-- JS-->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="{{ asset('vendor/bootstrap-5.3.7.bundle.min.js') }}"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="{{ asset('js/school-portal.js') }}"></script>
<script>
    let gradeChart = null;
    let classGradeChart = null;

    window.initGradeChart = function (canvasId, labels, data, title) {
        const ctx = document.getElementById(canvasId);
        if (!ctx) {
            console.log('Canvas not found: ' + canvasId);
            return;
        }

        // Force destroy any existing chart
        const existingChart = Chart.getChart(ctx);
        if (existingChart) {
            existingChart.destroy();
        }

        // Clear canvas
        ctx.getContext('2d').clearRect(0, 0, ctx.width, ctx.height);

        // Determine chart type based on canvas ID
        const chartType = canvasId === 'classGradeChart' ? 'bar' : 'line';

        const chart = new Chart(ctx, {
            type: chartType,
            data: {
                labels: labels,
                datasets: [{
                    label: title || 'Performance',
                    data: data,
                    borderColor: '#007bff',
                    backgroundColor: chartType === 'bar' ? 'rgba(0, 123, 255, 0.8)' : 'rgba(0, 123, 255, 0.1)',
                    borderWidth: chartType === 'bar' ? 1 : 3,
                    fill: chartType === 'line',
                    tension: chartType === 'line' ? 0.4 : undefined,
                    pointBackgroundColor: chartType === 'line' ? '#007bff' : undefined,
                    pointBorderColor: chartType === 'line' ? '#007bff' : undefined,
                    pointRadius: chartType === 'line' ? 4 : undefined,
                    pointHoverRadius: chartType === 'line' ? 6 : undefined
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        beginAtZero: true,
                        max: chartType === 'line' ? 10 : 100,
                        ticks: {
                            stepSize: chartType === 'line' ? 1 : 10
                        }
                    }
                }
            }
        });
    }
</script>

@if(session('toast'))
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const toastData = @json(session('toast'));
            showToast(toastData.type, toastData.message, toastData.title, toastData.icon);
        });
    </script>
@endif

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const loader = document.getElementById('livewire-loader');
        let activeRequests = 0;
        let safetyTimeout;

        function showLoader() {
            activeRequests++;
            loader.style.display = 'flex';

            // Safety timeout - hide after 10 seconds max
            clearTimeout(safetyTimeout);
            safetyTimeout = setTimeout(() => {
                activeRequests = 0;
                loader.style.display = 'none';
            }, 10000);
        }

        function hideLoader() {
            activeRequests--;
            if (activeRequests <= 0) {
                activeRequests = 0;
                clearTimeout(safetyTimeout);
                loader.style.display = 'none';
            }
        }

        document.addEventListener('livewire:init', () => {
            Livewire.hook('request', showLoader);
            Livewire.hook('response', hideLoader);
            Livewire.hook('commit', hideLoader);
            Livewire.hook('morph.updated', hideLoader);
        });
    });
</script>


@stack('scripts')

</body>

</html>
