<div>
    <form wire:submit.prevent="save">
        <div class="row">
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="title" class="form-label">Title <span class="text-danger">*</span></label>
                    <input type="text" class="form-control @error('title') is-invalid @enderror" 
                           id="title" wire:model="title" placeholder="Enter announcement title">
                    @error('title')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="alert_type" class="form-label">Alert Type <span class="text-danger">*</span></label>
                    <select class="form-select @error('alert_type') is-invalid @enderror" 
                            id="alert_type" wire:model="alert_type">
                        <option value="info">Info</option>
                        <option value="success">Success</option>
                        <option value="warning">Warning</option>
                        <option value="error">Error</option>
                    </select>
                    @error('alert_type')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
        </div>

        <div class="mb-3" wire:ignore>
            <label for="message" class="form-label">Message <span class="text-danger">*</span></label>
            <textarea class="form-control @error('message') is-invalid @enderror" 
                      id="message" wire:model="message" rows="4" 
                      placeholder="Enter announcement message"></textarea>
            @error('message')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="type" class="form-label">Display Type <span class="text-danger">*</span></label>
                    <select class="form-select @error('type') is-invalid @enderror" 
                            id="type" wire:model="type">
                        <option value="popup">Popup</option>
                        <option value="fixed">Fixed</option>
                    </select>
                    @error('type')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="target_type" class="form-label">Target <span class="text-danger">*</span></label>
                    <select class="form-select @error('target_type') is-invalid @enderror" 
                            id="target_type" wire:model.live="target_type">
                        @foreach($targetOptions as $key => $value)
                            <option value="{{ $key }}">{{ $value }}</option>
                        @endforeach
                    </select>
                    @error('target_type')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
        </div>

        @if($target_type === 'student')
            <div class="mb-3">
                <label for="target_id" class="form-label">Select Student</label>
                <select class="form-select @error('target_id') is-invalid @enderror" 
                        id="target_id" wire:model="target_id">
                    <option value="">Select a student</option>
                    @foreach($students as $student)
                        <option value="{{ $student->id }}">{{ $student->name }} ({{ $student->student_id }})</option>
                    @endforeach
                </select>
                @error('target_id')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>
        @elseif($target_type === 'staff')
            <div class="mb-3">
                <label for="target_id" class="form-label">Select Staff</label>
                <select class="form-select @error('target_id') is-invalid @enderror" 
                        id="target_id" wire:model="target_id">
                    <option value="">Select a staff member</option>
                    @foreach($staff as $staffMember)
                        <option value="{{ $staffMember->id }}">{{ $staffMember->name }}</option>
                    @endforeach
                </select>
                @error('target_id')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>
        @elseif($target_type === 'class')
            <div class="mb-3">
                <label for="target_id" class="form-label">Select Class</label>
                <select class="form-select @error('target_id') is-invalid @enderror" 
                        id="target_id" wire:model="target_id">
                    <option value="">Select a class</option>
                    @foreach($classes as $class)
                        <option value="{{ $class->id }}">{{ $class->name }}</option>
                    @endforeach
                </select>
                @error('target_id')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>
        @elseif($target_type === 'batch')
            <div class="mb-3">
                <label for="target_id" class="form-label">Select Batch</label>
                <select class="form-select @error('target_id') is-invalid @enderror" 
                        id="target_id" wire:model="target_id">
                    <option value="">Select a batch</option>
                    @foreach($batches as $batch)
                        <option value="{{ $batch->id }}">{{ $batch->name }} ({{ $batch->schoolClass->name }})</option>
                    @endforeach
                </select>
                @error('target_id')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>
        @endif

        <div class="row">
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="display_from" class="form-label">Display From</label>
                    <input type="datetime-local" class="form-control @error('display_from') is-invalid @enderror" 
                           id="display_from" wire:model="display_from">
                    @error('display_from')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="display_until" class="form-label">Display Until</label>
                    <input type="datetime-local" class="form-control @error('display_until') is-invalid @enderror" 
                           id="display_until" wire:model="display_until">
                    @error('display_until')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
        </div>



        <div class="d-flex justify-content-between">
            <a href="{{ route('announcements.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left me-2"></i>Back
            </a>
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-save me-2"></i>{{ $isEditing ? 'Update' : 'Create' }} Announcement
            </button>
        </div>
    </form>
</div>

@push('styles')
<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.css" rel="stylesheet">
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        // Prevent BS4/BS5 conflicts
        if (typeof bootstrap !== 'undefined') {
            window.bootstrap5 = bootstrap;
        }
        
        const messageContent = @json($message);
        
        $('#message').summernote({
            height: 200,
            toolbar: [
                ['style', ['bold', 'italic', 'underline']],
                ['font', ['strikethrough']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['insert', ['link', 'picture']],
                ['view', ['codeview']]
            ],
            callbacks: {
                onChange: function(contents, $editable) {
                    @this.set('message', contents);
                }
            }
        });
        
        if (messageContent) {
            $('#message').summernote('code', messageContent);
        }
        
        // Fix close button functionality
        $(document).on('click', '.note-modal .close', function(e) {
            e.preventDefault();
            $(this).closest('.note-modal').modal('hide');
        });
    });
</script>
@endpush