<div>
    <div class="row mb-3">
        <div class="col-md-6">
            <input type="text" class="form-control" placeholder="Search announcements..." wire:model.live="search">
        </div>
    </div>

    <!-- Desktop Table -->
    <div class="d-none d-lg-block">
        <table class="table table-striped">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Title</th>
                    <th>Type</th>
                    <th>Target</th>
                    <th>Alert Type</th>
                    <th>Status</th>
                    <th>Created By</th>
                    <th>Created At</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($announcements as $index => $announcement)
                    <tr>
                        <td>{{ $announcements->firstItem() + $index }}</td>
                        <td>{{ $announcement->title }}</td>
                        <td>
                            <span class="badge bg-{{ $announcement->type === 'popup' ? 'info' : 'warning' }}">
                                {{ ucfirst($announcement->type) }}
                            </span>
                        </td>
                        <td>{{ ucfirst(str_replace('_', ' ', $announcement->target_type)) }}</td>
                        <td>
                            <span class="badge bg-{{ $announcement->alert_type === 'success' ? 'success' : ($announcement->alert_type === 'warning' ? 'warning' : ($announcement->alert_type === 'error' ? 'danger' : 'info')) }}">
                                {{ ucfirst($announcement->alert_type) }}
                            </span>
                        </td>
                        <td>
                            <span class="badge bg-{{ $announcement->active ? 'success' : 'secondary' }}">
                                {{ $announcement->active ? 'Active' : 'Inactive' }}
                            </span>
                        </td>
                        <td>{{ $announcement->creator->name }}</td>
                        <td>{{ $announcement->created_at->format('M d, Y H:i') }}</td>
                        <td>
                            <div class="dropdown">
                                <button class="btn btn-sm btn-outline-secondary" type="button"
                                        data-bs-toggle="dropdown">
                                    <i class="fas fa-bars"></i>
                                </button>
                                <ul class="dropdown-menu dropdown-menu-sm">
                                    <li><a class="dropdown-item dropdown-item-sm"
                                           href="{{ route('announcements.edit', $announcement->announcement_id) }}">
                                            <i class="fas fa-edit me-2"></i>Edit
                                        </a></li>
                                    <li>
                                        <button class="dropdown-item dropdown-item-sm {{ $announcement->active ? 'text-warning' : 'text-success' }}"
                                                onclick="confirmToggle('{{ $announcement->announcement_id }}', '{{ $announcement->title }}', {{ $announcement->active ? 'true' : 'false' }})">
                                            <i class="fas fa-{{ $announcement->active ? 'pause' : 'play' }} me-2"></i>{{ $announcement->active ? 'Deactivate' : 'Activate' }}
                                        </button>
                                    </li>
                                    <li>
                                        <hr class="dropdown-divider">
                                    </li>
                                    <li>
                                        <button class="dropdown-item dropdown-item-sm text-danger"
                                                onclick="confirmDelete('{{ $announcement->announcement_id }}', '{{ $announcement->title }}')">
                                            <i class="fas fa-trash me-2"></i>Delete
                                        </button>
                                    </li>
                                </ul>
                            </div>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="9" class="text-center">No announcements found.</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <!-- Mobile/Tablet Cards -->
    <div class="d-lg-none">
        @forelse($announcements as $index => $announcement)
            <div class="card mb-3 shadow-sm">
                <div class="card-body p-3">
                    <div class="d-flex justify-content-between align-items-start mb-2">
                        <div class="flex-grow-1">
                            <div class="d-flex align-items-center mb-1">
                                <small class="text-muted me-2">#{{ $announcements->firstItem() + $index }}</small>
                                <span class="badge bg-{{ $announcement->type === 'popup' ? 'info' : 'warning' }} me-2">{{ ucfirst($announcement->type) }}</span>
                                <span class="badge bg-{{ $announcement->active ? 'success' : 'secondary' }}">{{ $announcement->active ? 'Active' : 'Inactive' }}</span>
                            </div>
                            <h6 class="card-title mb-1">{{ $announcement->title }}</h6>
                            <small class="text-muted">{{ $announcement->created_at->format('M d, Y H:i') }}</small>
                        </div>
                        <div class="dropdown">
                            <button class="btn btn-sm btn-outline-secondary" type="button"
                                    data-bs-toggle="dropdown">
                                <i class="fas fa-bars"></i>
                            </button>
                            <ul class="dropdown-menu dropdown-menu-end">
                                <li><a class="dropdown-item"
                                       href="{{ route('announcements.edit', $announcement->announcement_id) }}">
                                        <i class="fas fa-edit me-2"></i>Edit
                                    </a></li>
                                <li>
                                    <button class="dropdown-item {{ $announcement->active ? 'text-warning' : 'text-success' }}"
                                            onclick="confirmToggle('{{ $announcement->announcement_id }}', '{{ $announcement->title }}', {{ $announcement->active ? 'true' : 'false' }})">
                                        <i class="fas fa-{{ $announcement->active ? 'pause' : 'play' }} me-2"></i>{{ $announcement->active ? 'Deactivate' : 'Activate' }}
                                    </button>
                                </li>
                                <li>
                                    <hr class="dropdown-divider">
                                </li>
                                <li>
                                    <button class="dropdown-item text-danger"
                                            onclick="confirmDelete('{{ $announcement->announcement_id }}', '{{ $announcement->title }}')">
                                        <i class="fas fa-trash me-2"></i>Delete
                                    </button>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        @empty
            <div class="text-center py-5">
                <i class="fas fa-bullhorn fa-3x text-muted mb-3"></i>
                <p class="text-muted">No announcements found.</p>
            </div>
        @endforelse
    </div>

    {{ $announcements->links() }}
</div>

<script>
    function confirmDelete(announcementId, announcementTitle) {
        Swal.fire({
            title: 'Delete Announcement?',
            text: `Are you sure you want to delete "${announcementTitle}"? This action cannot be undone.`,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#dc3545',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Yes, Delete',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                @this.deleteAnnouncement(announcementId);
            }
        });
    }
    
    function confirmToggle(announcementId, announcementTitle, isActive) {
        const action = isActive ? 'deactivate' : 'activate';
        const actionTitle = isActive ? 'Deactivate' : 'Activate';
        
        Swal.fire({
            title: `${actionTitle} Announcement?`,
            text: `Are you sure you want to ${action} "${announcementTitle}"?`,
            icon: 'question',
            showCancelButton: true,
            confirmButtonColor: 'var(--bs-primary)',
            cancelButtonColor: '#6c757d',
            confirmButtonText: `Yes, ${actionTitle}`,
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                @this.toggleActive(announcementId);
            }
        });
    }
</script>