<div>
    <div class="row">
        <div class="col-md-6">
            <div class="card border-md-1 border-0 my-3">
                <div class="card-body">
                    <form wire:submit="assign">
                        <div class="mb-3">
                            <label for="selectedClass" class="form-label">Select Class</label>
                            <select wire:model.live="selectedClass" class="form-select @error('selectedClass') is-invalid @enderror">
                                <option value="">Choose a class...</option>
                                @foreach($classes as $class)
                                    <option value="{{ $class->id }}">{{ $class->display_name }}</option>
                                @endforeach
                            </select>
                            @error('selectedClass')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        @if($selectedClass)
                            <div class="mb-3">
                                <label for="selectedSubject" class="form-label">Select Subject</label>
                                <select wire:model="selectedSubject" class="form-select @error('selectedSubject') is-invalid @enderror">
                                    <option value="">Choose a subject...</option>
                                    @foreach($subjects as $subject)
                                        <option value="{{ $subject->id }}">{{ $subject->name }}</option>
                                    @endforeach
                                </select>
                                @error('selectedSubject')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="mb-3">
                                <label for="alias" class="form-label">Alias (Optional)</label>
                                <input type="text" wire:model="alias" class="form-control @error('alias') is-invalid @enderror" 
                                       placeholder="Enter custom name for this class">
                                @error('alias')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <div class="form-text">Leave empty to use the subject's original name</div>
                            </div>
                            
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-plus"></i> Assign Subject
                            </button>
                        @endif
                    </form>
                </div>
            </div>
        </div>
        
        <div class="col-md-6">
            @if($selectedClass && count($assignedSubjects) > 0)
                <div class="card border-md-1 border-0 my-3">
                    <div class="card-header">
                        <h6 class="mb-0">Assigned Subjects</h6>
                    </div>
                    <div class="card-body">
                        <div class="list-group">
                            @foreach($assignedSubjects as $subject)
                                <div class="list-group-item">
                                    <div class="d-flex justify-content-between align-items-start">
                                        <div class="flex-grow-1">
                                            <strong>{{ $subject->name }}</strong>
                                            @if($subject->schoolClasses->first() && $subject->schoolClasses->first()->pivot->alias)
                                                <br><small class="text-muted">Alias: {{ $subject->schoolClasses->first()->pivot->alias }}</small>
                                            @endif
                                        </div>
                                        <div class="d-flex gap-1">
                                            <button onclick="openEditAliasModal({{ $subject->id }}, '{{ $subject->name }}', '{{ $subject->schoolClasses->first() && $subject->schoolClasses->first()->pivot->alias ? $subject->schoolClasses->first()->pivot->alias : '' }}')"
                                                    class="btn btn-outline-primary btn-sm"
                                                    title="{{ $subject->schoolClasses->first() && $subject->schoolClasses->first()->pivot->alias ? 'Edit Alias' : 'Add Alias' }}">
                                                <i class="fas fa-edit"></i>
                                            </button>
                                            <button wire:click="confirmRemove({{ $subject->id }})"
                                                    class="btn btn-danger btn-sm"
                                                    title="Remove Subject">
                                                <i class="fas fa-times"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            @elseif($selectedClass)
                <div class="card border-md-1 border-0 my-3">
                    <div class="card-body text-center text-muted">
                        No subjects assigned to this class yet.
                    </div>
                </div>
            @endif
        </div>
    </div>

    <!-- Edit Alias Modal -->
    <div class="modal fade" id="editAliasModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header bg-primary">
                    <h5 class="modal-title text-white">Edit Subject Alias</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form id="editAliasForm">
                        <div class="mb-3">
                            <label class="form-label">Subject Name</label>
                            <input type="text" id="subjectName" class="form-control" readonly>
                        </div>
                        <div class="mb-3">
                            <label for="aliasInput" class="form-label">Alias</label>
                            <input type="text" id="aliasInput" class="form-control" placeholder="Enter alias (optional)">
                            <div class="form-text">Leave empty to use the subject's original name</div>
                        </div>
                        <div class="d-flex justify-content-end gap-2">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                            <button type="button" class="btn btn-primary" onclick="saveAlias()">Save Alias</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
    let currentSubjectId = null;

    function openEditAliasModal(subjectId, subjectName, currentAlias) {
        currentSubjectId = subjectId;
        document.getElementById('subjectName').value = subjectName;
        document.getElementById('aliasInput').value = currentAlias;
        
        const modal = new bootstrap.Modal(document.getElementById('editAliasModal'));
        modal.show();
    }

    function saveAlias() {
        const alias = document.getElementById('aliasInput').value;
        
        if (currentSubjectId) {
            @this.call('saveAlias', currentSubjectId, alias).then(() => {
                const modal = bootstrap.Modal.getInstance(document.getElementById('editAliasModal'));
                modal.hide();
            });
        }
    }
    </script>
</div>
