<div class="card">
    <div class="card-header">
        <h4 class="card-title mb-0">{{ $batchId ? 'Edit Batch' : 'Create New Batch' }}</h4>
    </div>
    <div class="card-body">
        <form wire:submit.prevent="save">
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="name" class="form-label">Batch Name <span class="text-danger">*</span></label>
                    <input type="text" class="form-control @error('name') is-invalid @enderror" 
                           id="name" wire:model="name" placeholder="Enter batch name">
                    @error('name')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="col-md-6 mb-3">
                    <label for="school_class_id" class="form-label">Class <span class="text-danger">*</span></label>
                    <select class="form-select @error('school_class_id') is-invalid @enderror" 
                            id="school_class_id" wire:model="school_class_id">
                        <option value="">Select a class</option>
                        @foreach($schoolClasses as $class)
                            <option value="{{ $class->id }}">{{ $class->display_name }}</option>
                        @endforeach
                    </select>
                    @error('school_class_id')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="capacity" class="form-label">Capacity <span class="text-danger">*</span></label>
                    <input type="number" class="form-control @error('capacity') is-invalid @enderror" 
                           id="capacity" wire:model="capacity" min="1" max="100">
                    @error('capacity')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>

            <div class="mb-3">
                <label for="description" class="form-label">Description</label>
                <textarea class="form-control @error('description') is-invalid @enderror" 
                          id="description" wire:model="description" rows="3" 
                          placeholder="Enter batch description (optional)"></textarea>
                @error('description')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="d-flex justify-content-between">
                <a href="{{ route('batches.index') }}" class="btn btn-secondary">
                    <i class="fas fa-arrow-left me-1"></i> Back
                </a>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save me-1"></i> {{ $batchId ? 'Update' : 'Create' }} Batch
                </button>
            </div>
        </form>
    </div>
</div>
