<div>
    <div class="row mb-3">
        <div class="col-md-4">
            <input type="text" class="form-control" placeholder="Search batches..." wire:model.live="search">
        </div>
        <div class="col-md-2">
            <select class="form-select" wire:model.live="classFilter">
                <option value="">All Classes</option>
                @foreach($classes as $class)
                    <option value="{{ $class->id }}">{{ $class->display_name }}</option>
                @endforeach
            </select>
        </div>
        <div class="col-md-3">
            <select class="form-select" wire:model.live="statusFilter">
                <option value="active">Active Batches</option>
                <option value="inactive">Inactive Batches</option>
                <option value="graduated">Graduated Batches</option>
                <option value="all">All Batches</option>
            </select>
        </div>
        <div class="col-md-3">
            <select class="form-select" wire:model.live="perPage">
                <option value="10">10 per page</option>
                <option value="25">25 per page</option>
                <option value="50">50 per page</option>
            </select>
        </div>
    </div>

    @if($batches->count() > 0)
        <!-- Batches Accordions -->
        <div>
            @foreach($batches as $index => $batch)
                <div class="card mb-2">
                    <div class="card-header p-0">
                        <div class="d-flex">
                            <div class="flex-grow-1 p-3" data-bs-toggle="collapse"
                                 data-bs-target="#batch{{ $batch->id }}" style="cursor: pointer;">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <strong>{{ $batch->name }}</strong>
                                        <span class="text-muted ms-2">|</span>
                                        <span class="ms-2">{{ $batch->schoolClass->display_name ?? 'N/A' }}</span>
                                        <span class="text-muted ms-2">|</span>
                                        <small class="text-muted ms-2">{{ $batch->students->count() }}/{{ $batch->capacity }} students</small>
                                    </div>
                                    <div>
                                        @if($batch->graduated)
                                            <span class="badge bg-info me-1">Graduated</span>
                                        @endif
                                        <span class="badge {{ $batch->is_active ? 'bg-success' : 'bg-secondary' }}">
                                            {{ $batch->is_active ? 'Active' : 'Inactive' }}
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="p-3 border-start">
                                <div class="dropdown">
                                    <button class="btn btn-sm btn-outline-secondary" type="button"
                                            data-bs-toggle="dropdown">
                                        <i class="fas fa-bars"></i>
                                    </button>
                                    <ul class="dropdown-menu dropdown-menu-sm">
                                        <li><a class="dropdown-item dropdown-item-sm"
                                               href="{{ route('batches.edit', $batch->id) }}">
                                                <i class="fas fa-edit me-2"></i>Edit
                                            </a></li>
                                        <li>
                                            <button
                                                class="dropdown-item dropdown-item-sm text-{{ $batch->is_active ? 'warning' : 'success' }}"
                                                onclick="confirmToggleStatus({{ $batch->id }}, {{ $batch->is_active ? 'false' : 'true' }})">
                                                <i class="fas fa-{{ $batch->is_active ? 'pause' : 'play' }} me-2"></i>{{ $batch->is_active ? 'Deactivate' : 'Activate' }}
                                            </button>
                                        </li>
                                        <li>
                                            <button class="dropdown-item dropdown-item-sm text-info"
                                                    onclick="confirmToggleGraduation({{ $batch->id }}, {{ $batch->graduated ? 'false' : 'true' }})">
                                                <i class="fas fa-graduation-cap me-2"></i>{{ $batch->graduated ? 'Unmark as Graduated' : 'Mark as Graduated' }}
                                            </button>
                                        </li>
                                        @can('admin')
                                        <li>
                                            <hr class="dropdown-divider">
                                        </li>
                                        <li>
                                            <button class="dropdown-item dropdown-item-sm text-danger"
                                                    onclick="confirmDelete({{ $batch->id }})">
                                                <i class="fas fa-trash me-2"></i>Delete
                                            </button>
                                        </li>
                                        @endcan
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="collapse" id="batch{{ $batch->id }}">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <p><strong>Class:</strong> {{ $batch->schoolClass->display_name ?? 'N/A' }}</p>
                                    <p><strong>Capacity:</strong> {{ $batch->capacity }}</p>
                                    <p><strong>Current Students:</strong> {{ $batch->students->count() }}/{{ $batch->capacity }}</p>
                                </div>
                                <div class="col-md-6">
                                    <p><strong>Status:</strong>
                                        <span class="badge {{ $batch->is_active ? 'bg-success' : 'bg-secondary' }}">
                                            {{ $batch->is_active ? 'Active' : 'Inactive' }}
                                        </span>
                                    </p>
                                    <p><strong>Graduated:</strong>
                                        <span class="badge {{ $batch->graduated ? 'bg-info' : 'bg-secondary' }}">
                                            {{ $batch->graduated ? 'Yes' : 'No' }}
                                        </span>
                                    </p>
                                    <p><strong>Created:</strong> {{ $batch->created_at->format('M d, Y') }}</p>
                                </div>
                            </div>
                            @if($batch->description)
                                <hr>
                                <p><strong>Description:</strong> {{ $batch->description }}</p>
                            @endif
                        </div>
                    </div>
                </div>
            @endforeach
        </div>

        <!-- Pagination -->
        @if($batches->hasPages())
            <div class="d-flex justify-content-center mt-4">
                {{ $batches->links('custom.pagination') }}
            </div>
        @endif
    @else
        <!-- No Batches Notification Card -->
        <div class="alert text-center py-5">
            <div class="mb-3">
                <i class="fas fa-layer-group fa-3x text-muted"></i>
            </div>
            <h4 class="fw-bold mb-3">No Batches Found</h4>
            <p class="mb-4">You haven't created any batches yet. Get started by creating your first batch.</p>
            <a href="{{ route('batches.create') }}" class="btn btn-primary btn-lg">
                <i class="fas fa-plus me-2"></i>Create Your First Batch
            </a>
        </div>
    @endif
</div>

<script>
    function confirmDelete(batchId) {
        Swal.fire({
            title: 'Are you sure?',
            text: "This action cannot be undone!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: 'var(--primary-color)',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                @this.
                call('deleteBatch', batchId);
            }
        });
    }

    function confirmToggleStatus(batchId, newStatus) {
        const action = newStatus === 'true' ? 'activate' : 'deactivate';
        Swal.fire({
            title: `${action.charAt(0).toUpperCase() + action.slice(1)} Batch?`,
            text: `Are you sure you want to ${action} this batch?`,
            icon: 'question',
            showCancelButton: true,
            confirmButtonColor: 'var(--primary-color)',
            cancelButtonColor: '#6c757d',
            confirmButtonText: `Yes, ${action} it!`
        }).then((result) => {
            if (result.isConfirmed) {
                @this.
                call('toggleStatus', batchId);
            }
        });
    }

    function confirmToggleGraduation(batchId, newStatus) {
        if (newStatus === true) {
            Swal.fire({
                title: 'Mark as graduated?',
                text: 'Are you sure this batch has graduated and is no longer attending classes?',
                icon: 'question',
                showCancelButton: true,
                confirmButtonColor: 'var(--primary-color)',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Yes, mark as graduated!'
            }).then((result) => {
                if (result.isConfirmed) {
                    @this.
                    call('toggleGraduation', batchId);
                }
            });
        } else {
            Swal.fire({
                title: 'Unmark as graduated?',
                text: 'Are you sure you want to restore this batch to active session?',
                icon: 'question',
                showCancelButton: true,
                confirmButtonColor: 'var(--primary-color)',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Yes, restore!'
            }).then((result) => {
                if (result.isConfirmed) {
                    @this.
                    call('toggleGraduation', batchId);
                }
            });
        }
    }
</script>
