<div class="my-4">
    @if(count($fixedAnnouncements) > 0)
        <div class="row" id="fixed-announcements">
            @foreach($fixedAnnouncements as $announcement)
                <div class="col-lg-4 col-md-6 col-sm-6 mb-3" data-announcement-id="{{ $announcement['id'] }}">
                    <div class="card border-{{ $announcement['alert_type'] === 'error' ? 'danger' : $announcement['alert_type'] }}">
                        <div class="card-header bg-{{ $announcement['alert_type'] === 'error' ? 'danger' : $announcement['alert_type'] }} {{ in_array($announcement['alert_type'], ['warning', 'info']) ? 'text-dark' : 'text-white' }}">
                            <span class="fw-bold mb-0">{{ $announcement['title'] }}</span>
                        </div>
                        <div class="card-body">
                            <div class="card-text mb-0">{!! $announcement['message'] !!}</div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    @endif
</div>

@if(count($popupAnnouncements) > 0)
    @push('scripts')
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                const allAnnouncements = @json($popupAnnouncements);
                const dismissed = JSON.parse(sessionStorage.getItem('dismissedAnnouncements') || '[]');
                const announcements = allAnnouncements.filter(a => !dismissed.includes(a.id));
                let currentIndex = 0;

                function showNextAnnouncement() {
                    if (currentIndex < announcements.length) {
                        const announcement = announcements[currentIndex];
                        const alertType = announcement.alert_type === 'error' ? 'error' : announcement.alert_type;
                        
                        Swal.fire({
                            title: `<div style="display: flex; align-items: center; font-size: 1.3rem;"><i class="fas fa-${alertType === 'success' ? 'check-circle' : (alertType === 'warning' ? 'exclamation-triangle' : (alertType === 'error' ? 'times-circle' : 'info-circle'))} me-2"></i>${announcement.title}</div>`,
                            html: announcement.message,
                            showCancelButton: true,
                            confirmButtonText: 'Hide for this session',
                            cancelButtonText: 'Close',
                            confirmButtonColor: '#6c757d',
                            cancelButtonColor: 'var(--bs-primary)',
                            width: 'auto',
                            heightAuto: false,
                            allowOutsideClick: false,
                            customClass: {
                                popup: 'swal-responsive-popup',
                                htmlContainer: 'text-start swal-scrollable-content'
                            }
                        }).then((result) => {
                            if (result.isConfirmed) {
                                // Hide for session button clicked - store in sessionStorage
                                let dismissed = JSON.parse(sessionStorage.getItem('dismissedAnnouncements') || '[]');
                                if (!dismissed.includes(announcement.id)) {
                                    dismissed.push(announcement.id);
                                    sessionStorage.setItem('dismissedAnnouncements', JSON.stringify(dismissed));
                                }
                            }
                            // Both buttons proceed to next announcement
                            currentIndex++;
                            showNextAnnouncement();
                        });
                    }
                }

                showNextAnnouncement();
            });
        </script>
    @endpush
@endif

@push('styles')
    <style>
    .swal-responsive-popup {
        max-width: 40vw !important;
        width: auto !important;
        max-height: 95vh !important;
        height: auto !important;
        padding-bottom: 0 !important;
    }
    .swal-mobile {
        max-width: 95vw !important;
    }
    .swal-mobile-actions {
        justify-content: center !important;
        text-align: center !important;
    }
    .swal-mobile-actions .swal2-confirm {
        margin: 0 auto !important;
        font-size: 14px !important;
    }
    .card-body {
        max-height: 50vh;
        overflow-y: auto;
    }

    @media (max-width: 991px) {
        .swal-responsive-popup {
            max-width: 95vw !important;
        }
    }
    .swal-scrollable-content {
        max-height: 50vh !important;
        overflow-y: auto !important;
        text-align: left !important;
        font-size: 16px !important;
        border-top: 2px solid #ccc !important;
        border-bottom: 2px solid #ccc !important;
        padding: 15px !important;
    }
    .swal2-html-container img {
        padding: 10px !important;
        margin: 10px 0 !important;
        max-width: calc(100% - 20px) !important;
        height: auto !important;
        display: block !important;
        box-sizing: border-box !important;
    }
    .swal-responsive-popup .swal2-actions {
        display: flex !important;
        justify-content: flex-end !important;
        width: 100% !important;
        background-color: #f8f9fa !important;
        border-top: 1px solid #dee2e6 !important;
        padding: 8px 20px !important;
        margin: 0 !important;
    }
    .swal-responsive-popup .swal2-confirm {
        margin-left: auto !important;
        margin-right: 10px !important;
    }
    @media (max-width: 991px) {
        .swal-responsive-popup .swal2-actions {
            justify-content: center !important;
            padding: 6px 15px !important;
            overflow: hidden !important;
            box-sizing: border-box !important;
        }
        .swal-responsive-popup .swal2-confirm {
            margin: 0 !important;
            max-width: calc(100% - 20px) !important;
            white-space: nowrap !important;
            overflow: hidden !important;
            text-overflow: ellipsis !important;
        }
    }
    </style>
@endpush