<div>
    <form wire:submit.prevent="save">
        <div class="row">
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="title" class="form-label">Title <span class="text-danger">*</span></label>
                    <input type="text" class="form-control @error('title') is-invalid @enderror" 
                           id="title" wire:model="title" placeholder="Enter payment title">
                    @error('title')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            <div class="col-md-3">
                <div class="mb-3">
                    <label for="amount" class="form-label">Amount <span class="text-danger">*</span></label>
                    <input type="number" step="0.01" class="form-control @error('amount') is-invalid @enderror" 
                           id="amount" wire:model="amount" placeholder="0.00">
                    @error('amount')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            <div class="col-md-3">
                <div class="mb-3">
                    <label for="currency" class="form-label">Currency <span class="text-danger">*</span></label>
                    <select class="form-select @error('currency') is-invalid @enderror" 
                            id="currency" wire:model="currency">
                        <option value="NGN">NGN</option>
                        <option value="USD">USD</option>
                        <option value="EUR">EUR</option>
                        <option value="GBP">GBP</option>
                    </select>
                    @error('currency')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
        </div>

        <div class="mb-3">
            <label for="description" class="form-label">Description <span class="text-danger">*</span></label>
            <textarea class="form-control @error('description') is-invalid @enderror" 
                      id="description" wire:model="description" rows="3" 
                      placeholder="Enter payment description"></textarea>
            @error('description')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="target_type" class="form-label">Target Type <span class="text-danger">*</span></label>
                    <select class="form-select @error('target_type') is-invalid @enderror" 
                            id="target_type" wire:model.live="target_type">
                        <option value="student">Student</option>
                        <option value="class">Class</option>
                        <option value="batch">Batch</option>
                        <option value="all_students">All Students</option>
                    </select>
                    @error('target_type')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            <div class="col-md-6">
                @if($target_type === 'all_students')
                    <div class="mb-3">
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle me-2"></i>
                            This payment request will apply to all students in the school.
                        </div>
                    </div>
                @elseif($target_type === 'student')
                    <div class="mb-3">
                        <label for="student_search" class="form-label">Search Student</label>
                        <div class="position-relative">
                            <input type="text" class="form-control" id="student_search" 
                                   wire:model.live.debounce.300ms="student_search" 
                                   placeholder="Type student name or ID...">
                            @if($show_search_results && count($search_results) > 0)
                                <div class="dropdown-menu show w-100" style="max-height: 200px; overflow-y: auto;">
                                    @foreach($search_results as $student)
                                        <button type="button" class="dropdown-item hover-bg-light" 
                                                wire:click="selectStudentFromSearch({{ $student->id }})">
                                            <strong>{{ $student->name }}</strong>
                                            @if($student->student_id)<small class="text-muted">({{ $student->student_id }})</small>@endif
                                            <br><small class="text-muted">{{ $student->batch->schoolClass->name ?? 'N/A' }} - {{ $student->batch->name ?? 'N/A' }}</small>
                                        </button>
                                    @endforeach
                                </div>
                            @endif
                        </div>
                        <small class="text-muted">Type at least 2 characters to search</small>
                    </div>
                @else
                    <div class="mb-3">
                        <label for="target_id" class="form-label">
                            Select {{ ucfirst($target_type) }} <span class="text-danger">*</span>
                        </label>
                        <select class="form-select @error('target_id') is-invalid @enderror" 
                                id="target_id" wire:model="target_id">
                            <option value="">Choose {{ ucfirst($target_type) }}</option>
                            @if($target_type === 'class')
                                @foreach($classes as $class)
                                    <option value="{{ $class->id }}">{{ $class->alias ?: $class->name }}</option>
                                @endforeach
                            @elseif($target_type === 'batch')
                                @foreach($batches as $batch)
                                    <option value="{{ $batch->id }}">{{ $batch->name }} ({{ $batch->schoolClass->name ?? 'N/A' }})</option>
                                @endforeach
                            @endif
                        </select>
                        @error('target_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                @endif
            </div>
        </div>

        @if($target_type === 'student')
        <!-- Class/Batch/Student Selection Row -->
        <div class="row">
            <div class="col-md-4">
                <div class="mb-3">
                    <label for="selected_class_id" class="form-label">Class</label>
                    <select class="form-select" id="selected_class_id" wire:model.live="selected_class_id">
                        <option value="">Choose Class</option>
                        @foreach($classes as $class)
                            <option value="{{ $class->id }}">{{ $class->alias ?: $class->name }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="col-md-4">
                <div class="mb-3">
                    <label for="selected_batch_id" class="form-label">Batch</label>
                    <select class="form-select" id="selected_batch_id" wire:model.live="selected_batch_id" 
                            {{ !$selected_class_id ? 'disabled' : '' }}>
                        <option value="">Choose Batch</option>
                        @foreach($batches as $batch)
                            <option value="{{ $batch->id }}">{{ $batch->name }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="col-md-4">
                <div class="mb-3">
                    <label for="target_id" class="form-label">Student <span class="text-danger">*</span></label>
                    <select class="form-select @error('target_id') is-invalid @enderror" 
                            id="target_id" wire:model="target_id" 
                            {{ !$selected_batch_id ? 'disabled' : '' }}>
                        <option value="">Choose Student</option>
                        @foreach($batch_students as $student)
                            <option value="{{ $student->id }}">
                                {{ $student->name }} @if($student->student_id)({{ $student->student_id }})@endif
                            </option>
                        @endforeach
                    </select>
                    @error('target_id')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
        </div>
        @endif

        <div class="d-flex justify-content-between">
            <a href="{{ route('payment-requests.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left me-2"></i>Back
            </a>
            <button type="submit" class="btn btn-primary" wire:loading.attr="disabled">
                <i class="fas fa-save me-2"></i>
                <span wire:loading.remove>Create Payment Request</span>
                <span wire:loading>Creating...</span>
            </button>
        </div>
    </form>
</div>