<div>
    <!-- Filters -->
    <div class="row mb-3">
        <div class="col-md-6">
            <input type="text" class="form-control" placeholder="Search payments..." wire:model.live="search">
        </div>
        <div class="col-md-3">
            <select class="form-select" wire:model.live="statusFilter">
                <option value="">All Status</option>
                <option value="active">Active</option>
                <option value="cancelled">Cancelled</option>
                <option value="settled">Settled</option>
            </select>
        </div>
        <div class="col-md-3">
            <select class="form-select" wire:model.live="perPage">
                <option value="5">5 per page</option>
                <option value="10">10 per page</option>
                <option value="25">25 per page</option>
                <option value="50">50 per page</option>
            </select>
        </div>
    </div>

    @if($payments->count() > 0)
        <!-- Payment Request Accordions -->
        <div>
            @foreach($payments as $index => $payment)
                <div class="card mb-2">
                    <div class="card-header p-0">
                        <div class="d-flex">
                            <div class="flex-grow-1 p-3" data-bs-toggle="collapse"
                                 data-bs-target="#payment{{ $payment->id }}" style="cursor: pointer;">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <span
                                            class="badge bg-secondary me-2">{{ $payments->firstItem() + $index }}</span>
                                        <strong>{{ $payment->title }}</strong>
                                        <span class="text-muted ms-2">|</span>
                                        <span class="ms-2">
                                                {{ $payment->target_name }}
                                        </span>
                                        <span class="text-muted ms-2">|</span>
                                        <small
                                            class="text-muted ms-2">{{ $payment->currency_symbol }}{{ number_format($payment->amount, 0) }}</small>
                                    </div>
                                    <div>
                                        <span
                                            class="badge bg-{{ $payment->status === 'settled' ? 'success' : ($payment->status === 'cancelled' ? 'danger' : 'primary') }}">
                                            {{ ucfirst($payment->status) }}
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="p-3 border-start" onclick="event.stopPropagation();">
                                <div class="dropdown">
                                    <button class="btn btn-sm btn-outline-secondary" type="button"
                                            data-bs-toggle="dropdown">
                                        <i class="fas fa-bars"></i>
                                    </button>
                                    <ul class="dropdown-menu dropdown-menu-sm dropdown-menu-end">
                                        @if(!in_array($payment->status, ['settled', 'cancelled']))
                                            <li>
                                                <button class="dropdown-item dropdown-item-sm"
                                                        wire:click="openEditModal({{ $payment->id }})">
                                                    <i class="fas fa-edit me-2"></i>Edit
                                                </button>
                                            </li>
                                            <li>
                                                <button class="dropdown-item dropdown-item-sm"
                                                        wire:click="openUpdateModal({{ $payment->id }})">
                                                    <i class="fas fa-sync me-2"></i>Update Status
                                                </button>
                                            </li>
                                        @else
                                            <li>
                                                <span class="dropdown-item dropdown-item-sm text-muted">
                                                    <i class="fas fa-lock me-2"></i>No actions available
                                                </span>
                                            </li>
                                        @endif
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="collapse" id="payment{{ $payment->id }}">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <h6 class="text-primary">Payment Details</h6>
                                    <p><strong>Description:</strong> {{ $payment->description }}</p>
                                    <p>
                                        <strong>Amount:</strong> {{ $payment->currency_symbol }}{{ number_format($payment->amount, 0) }}
                                    </p>
                                    <p><strong>Amount
                                            Paid:</strong> {{ $payment->currency_symbol }}{{ number_format($payment->amount_paid, 0) }}
                                    </p>
                                    <p><strong>Balance:</strong>
                                        <span class="{{ $payment->balance > 0 ? 'text-danger' : 'text-success' }}">
                                            {{ $payment->currency_symbol }}{{ number_format($payment->balance, 0) }}
                                        </span>
                                    </p>
                                    <p><strong>Created By:</strong> {{ $payment->createdBy->name }}</p>
                                    <p><strong>Created Date:</strong> {{ $payment->created_at->format('M d, Y H:i') }}
                                    </p>
                                </div>
                                <div class="col-md-6">
                                    @if($payment->payments->count() > 0)
                                        <h6 class="text-primary">Payment History</h6>
                                        <div class="table-responsive">
                                            <table class="table table-sm">
                                                <thead>
                                                <tr>
                                                    <th>Date</th>
                                                    <th>Amount</th>
                                                    <th>Notes</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                @foreach($payment->payments as $paymentRecord)
                                                    <tr>
                                                        <td>{{ $paymentRecord->payment_date->format('M d, Y') }}</td>
                                                        <td>{{ $payment->currency_symbol }}{{ number_format($paymentRecord->amount, 0) }}</td>
                                                        <td>{{ $paymentRecord->notes ?: '-' }}</td>
                                                    </tr>
                                                @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    @endif

                                    @if($payment->meta && is_array($payment->meta) && count($payment->meta) > 0)
                                        <h6 class="text-primary mt-3">Partial Payment Records</h6>
                                        <div class="table-responsive">
                                            <table class="table table-sm">
                                                <thead>
                                                <tr>
                                                    <th>Date</th>
                                                    <th>Amount</th>
                                                    <th>Notes</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                @foreach($payment->meta as $record)
                                                    <tr>
                                                        <td>{{ \Carbon\Carbon::parse($record['date'])->format('M d, Y') }}</td>
                                                        <td>{{ $payment->currency_symbol }}{{ number_format($record['amount'], 0) }}</td>
                                                        <td>{{ $record['notes'] ?? '-' }}</td>
                                                    </tr>
                                                @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>

        @if($payments->hasPages())
            <div class="d-flex justify-content-center mt-4">
                {{ $payments->links('custom.pagination') }}
            </div>
        @endif
    @else
        <div class="alert text-center py-5">
            <div class="mb-3">
                <i class="fas fa-credit-card fa-3x text-muted"></i>
            </div>
            <h4 class="fw-bold mb-3">No Payment Requests Found</h4>
            <p class="mb-4">No payment requests match your current filters.</p>
        </div>
    @endif

    <!-- Update Status Modal -->
    @if($showUpdateModal)
        <div class="modal fade show" style="display: block;" tabindex="-1">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title text-light">Update Payment Status</h5>
                        <button type="button" class="btn-close" wire:click="closeUpdateModal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">Status</label>
                            <select class="form-select" wire:model.live="newStatus">
                                <option value="active">Active</option>
                                <option value="cancelled">Cancelled</option>
                                <option value="settled">Settled</option>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" wire:click="closeUpdateModal">Cancel</button>
                        <button type="button" class="btn btn-primary" wire:click="updatePaymentStatus">Update</button>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-backdrop fade show"></div>
    @endif

    <!-- Edit Modal -->
    @if($showEditModal)
        <div class="modal fade show" style="display: block;" tabindex="-1">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title text-light">Edit Payment Request</h5>
                        <button type="button" class="btn-close" wire:click="closeEditModal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">Title</label>
                            <input type="text" class="form-control" wire:model="editTitle">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Description</label>
                            <textarea class="form-control" wire:model="editDescription" rows="3"></textarea>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Amount</label>
                            <input type="number" class="form-control" wire:model="editAmount" step="0.01">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Currency</label>
                            <select class="form-select" wire:model="editCurrency">
                                <option value="NGN">NGN</option>
                                <option value="USD">USD</option>
                                <option value="EUR">EUR</option>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" wire:click="closeEditModal">Cancel</button>
                        <button type="button" class="btn btn-primary" wire:click="updatePaymentRequest">Update</button>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-backdrop fade show"></div>
    @endif
</div>
