<div>
    <div class="row">
        <div class="col-md-6">
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="mb-0">Payment Information</h6>
                </div>
                <div class="card-body">
                    <p><strong>Payment Request:</strong> {{ $payment->paymentRequest?->title ?? 'Direct Payment' }}</p>
                    <p><strong>Student:</strong> {{ $payment->user->name }}</p>
                    <p><strong>Amount:</strong> {{ $payment->currency_symbol }}{{ number_format($payment->amount) }}</p>
                    <p><strong>Current Status:</strong>
                        <span
                            class="badge bg-{{ $payment->status === 'successful' ? 'success' : ($payment->status === 'failed' ? 'danger' : ($payment->status === 'cancelled' ? 'secondary' : 'warning')) }}">
                            {{ ucfirst($payment->status) }}
                        </span>
                    </p>
                    <p><strong>Date Created:</strong> {{ $payment->created_at->format('M d, Y H:i') }}</p>
                    @if($payment->created_at != $payment->updated_at)
                        <p><strong>Last Modified:</strong> {{ $payment->updated_at->format('M d, Y H:i') }}</p>
                        <p><strong>Modified By:</strong> {{ $payment->recordedBy->name ?? 'System' }}</p>
                    @endif
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">Update Payment Status</h6>
                </div>
                <div class="card-body">
                    <form wire:submit.prevent="confirmUpdate">
                        <div class="mb-3">
                            <label for="status" class="form-label">Status</label>
                            <select class="form-select" id="status" wire:model.live="status"
                                    @if(!$this->canUpdateStatus) disabled @endif>
                                <option value="successful" @if($status === 'successful') selected @endif>Fully Paid
                                </option>
                                <option value="partial" @if($status === 'partial') selected @endif>Partial Payment
                                </option>
                                <option value="failed" @if($status === 'failed') selected @endif>Failed</option>
                                <option value="cancelled" @if($status === 'cancelled') selected @endif>Cancelled
                                </option>
                                <option value="pending" @if($status === 'pending') selected @endif>Pending</option>
                            </select>
                            @if(!$this->canUpdateStatus)
                                <div class="form-text text-muted">Status cannot be changed once finalized</div>
                            @endif
                        </div>

                        @if($status === 'partial')
                            <div class="mb-3">
                                <label for="partialAmount" class="form-label">Amount Received</label>
                                <div class="input-group">
                                    <span class="input-group-text">{{ $payment->currency_symbol }}</span>
                                    <input type="number" class="form-control" id="partialAmount"
                                           wire:model.live="partialAmount" step="0.01" min="0.01"
                                           max="{{ $payment->amount }}" placeholder="0.00">
                                </div>
                                @error('partialAmount')
                                <div class="text-danger small">{{ $message }}</div> @enderror
                            </div>

                            @if($partialAmount && $balance > 0)
                                <div class="alert alert-info">
                                    <strong>Balance
                                        Remaining:</strong> {{ $payment->currency_symbol }}{{ number_format($balance, 2) }}
                                    <br>
                                    <small>A new payment request will be created for the balance amount.</small>
                                </div>
                            @endif
                        @endif

                        <div class="mb-3">
                            <label for="notes" class="form-label">Notes</label>
                            <textarea class="form-control" id="notes" wire:model="notes" rows="3"
                                      placeholder="Add notes about this payment..."
                                      @if(!$this->canUpdateStatus && !$editingNotes) readonly @endif></textarea>
                        </div>

                        <!-- Desktop Layout -->
                        <div class="d-none d-lg-flex justify-content-between">
                            <a href="{{ route('payments.history') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left me-2"></i>Back
                            </a>
                            <div>
                                @if(!$this->canUpdateStatus)
                                    @if(!$editingNotes)
                                        <button type="button" class="btn btn-outline-primary me-2"
                                                wire:click="enableNotesEditing">
                                            <i class="fas fa-edit me-2"></i>Edit Notes
                                        </button>
                                    @else
                                        <button type="button" class="btn btn-outline-primary me-2"
                                                wire:click="updateNotes" wire:loading.attr="disabled">
                                            <i class="fas fa-save me-2"></i>
                                            <span wire:loading.remove wire:target="updateNotes">Save Notes</span>
                                            <span wire:loading wire:target="updateNotes">Saving...</span>
                                        </button>
                                    @endif
                                @endif
                                <button type="submit" class="btn btn-primary" wire:loading.attr="disabled"
                                        @if(!$this->canUpdateStatus) disabled @endif>
                                    <i class="fas fa-save me-2"></i>
                                    <span wire:loading.remove wire:target="confirmUpdate">Update Status</span>
                                    <span wire:loading wire:target="confirmUpdate">Processing...</span>
                                </button>
                            </div>
                        </div>

                        <!-- Mobile/Medium Layout -->
                        <div class="d-lg-none">
                            <!-- Action Buttons Row -->
                            <div class="d-flex justify-content-end mb-3">
                                @if(!$this->canUpdateStatus)
                                    @if(!$editingNotes)
                                        <button type="button" class="btn btn-outline-primary me-2"
                                                wire:click="enableNotesEditing">
                                            <i class="fas fa-edit me-2"></i>Edit Notes
                                        </button>
                                    @else
                                        <button type="button" class="btn btn-outline-primary me-2"
                                                wire:click="updateNotes" wire:loading.attr="disabled">
                                            <i class="fas fa-save me-2"></i>
                                            <span wire:loading.remove wire:target="updateNotes">Save Notes</span>
                                            <span wire:loading wire:target="updateNotes">Saving...</span>
                                        </button>
                                    @endif
                                @endif
                                <button type="submit" class="btn btn-primary" wire:loading.attr="disabled"
                                        @if(!$this->canUpdateStatus) disabled @endif>
                                    <i class="fas fa-save me-2"></i>
                                    <span wire:loading.remove wire:target="confirmUpdate">Update Status</span>
                                    <span wire:loading wire:target="confirmUpdate">Processing...</span>
                                </button>
                            </div>
                            
                            <!-- Back Button Row -->
                            <div class="text-start">
                                <a href="{{ route('payments.history') }}" class="btn btn-secondary">
                                    <i class="fas fa-arrow-left me-2"></i>Back
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
