<div>
        <div class="row">
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="batchSearch" class="form-label">Search Batch</label>
                    <input wire:model.live="batchSearch" type="text" id="batchSearch" class="form-control" 
                           placeholder="Search by batch name...">
                    
                    @if($batchSearch && $searchResults->count() > 0)
                        <div class="mt-2 border rounded" style="max-height: 200px; overflow-y: auto;">
                            @foreach($searchResults as $batch)
                                <div class="p-2 border-bottom cursor-pointer hover-bg-light" 
                                     wire:click="selectBatch({{ $batch->id }})" 
                                     style="cursor: pointer;"
                                     onmouseover="this.style.backgroundColor='#f8f9fa'" 
                                     onmouseout="this.style.backgroundColor='white'">
                                    <strong>{{ $batch->name }}</strong>
                                    <br><small class="text-muted">{{ $batch->schoolClass->display_name }} ({{ $batch->current_students }}/{{ $batch->capacity }} students)</small>
                                </div>
                            @endforeach
                        </div>
                    @endif
                </div>
                <div class="mb-3">
                    <label for="batchId" class="form-label">Or Select from Dropdown</label>
                    <select wire:model.live="batchId" id="batchId" class="form-select">
                        <option value="">Select batch to promote</option>
                        @foreach($batches as $batch)
                            <option value="{{ $batch->id }}">
                                {{ $batch->name }} ({{ $batch->schoolClass->display_name }})
                            </option>
                        @endforeach
                    </select>
                    @error('batchId') <div class="text-danger">{{ $message }}</div> @enderror
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="toClassId" class="form-label">To Class</label>
                    <select wire:model.live="toClassId" id="toClassId" class="form-select">
                        <option value="">Select destination class</option>
                        @foreach($classes as $class)
                            <option value="{{ $class->id }}">{{ $class->display_name }}</option>
                        @endforeach
                    </select>
                    @error('toClassId') <div class="text-danger">{{ $message }}</div> @enderror
                </div>
                
                <div class="mb-3">
                    <div class="form-check">
                        <input wire:model.live="createNewBatch" class="form-check-input" type="checkbox" id="createNewBatch">
                        <label class="form-check-label" for="createNewBatch">
                            Create new batch
                        </label>
                    </div>
                </div>
                
                @if(!$createNewBatch && !empty($availableBatches))
                    <div class="mb-3">
                        <label for="toBatchId" class="form-label">Select Destination Batch</label>
                        <select wire:model="toBatchId" id="toBatchId" class="form-select">
                            <option value="">Select destination batch</option>
                            @foreach($availableBatches as $batch)
                                <option value="{{ $batch->id }}">
                                    {{ $batch->name }} ({{ $batch->current_students }}/{{ $batch->capacity }})
                                </option>
                            @endforeach
                        </select>
                        @error('toBatchId') <div class="text-danger">{{ $message }}</div> @enderror
                    </div>
                @endif
            </div>
        </div>
        
        @if($demotionWarning)
            <div class="alert alert-warning mb-3">
                <i class="fas fa-exclamation-triangle me-2"></i>{{ $demotionWarning }}
            </div>
        @endif
        
        @if($selectedBatch)
            <div class="card mb-3">
                <div class="card-header">
                    <h6 class="mb-0">Batch Information</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <p><strong>Batch Name:</strong> {{ $selectedBatch->name }}</p>
                            <p><strong>Current Class:</strong> {{ $selectedBatch->schoolClass->display_name }}</p>
                        </div>
                        <div class="col-md-6">
                            <p><strong>Total Students:</strong> {{ $selectedBatch->students->count() }}</p>
                            @if($onlyEligible && $eligibleCount > 0)
                                <p><strong>Eligible Students:</strong> <span class="text-success">{{ $eligibleCount }}</span></p>
                            @endif
                            <p><strong>Capacity:</strong> {{ $selectedBatch->capacity }}</p>
                        </div>
                    </div>
                </div>
            </div>
        @endif
        
        <div class="mb-3">
            <div class="form-check form-switch">
                <input wire:model.live="onlyEligible" class="form-check-input" type="checkbox" id="onlyEligible">
                <label class="form-check-label" for="onlyEligible">
                    Only promote eligible students (those who meet pass percentage criteria)
                </label>
            </div>
        </div>
        
        <div class="d-flex justify-content-end">
            <button type="button" wire:click="confirmPromotion" class="btn btn-primary" 
                    @if(!$batchId || !$toClassId || (!$createNewBatch && !$toBatchId)) disabled @endif>
                <i class="fas fa-arrow-up me-2"></i>Promote Batch
            </button>
        </div>
</div>