<div>
        <div class="row">
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="fromClassId" class="form-label">From Class</label>
                    <select wire:model.live="fromClassId" id="fromClassId" class="form-select">
                        <option value="">Select source class</option>
                        @foreach($classes as $class)
                            <option value="{{ $class->id }}">{{ $class->display_name }}</option>
                        @endforeach
                    </select>
                    @error('fromClassId') <div class="text-danger">{{ $message }}</div> @enderror
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="toClassId" class="form-label">To Class</label>
                    <select wire:model.live="toClassId" id="toClassId" class="form-select">
                        <option value="">Select destination class</option>
                        @foreach($classes as $class)
                            <option value="{{ $class->id }}">{{ $class->display_name }}</option>
                        @endforeach
                    </select>
                    @error('toClassId') <div class="text-danger">{{ $message }}</div> @enderror
                </div>
            </div>
        </div>
        
        @if($demotionWarning)
            <div class="alert alert-warning mb-3">
                <i class="fas fa-exclamation-triangle me-2"></i>{{ $demotionWarning }}
            </div>
        @endif
        
        <div class="mb-3">
            <div class="form-check form-switch">
                <input wire:model="onlyEligible" class="form-check-input" type="checkbox" id="onlyEligible">
                <label class="form-check-label" for="onlyEligible">
                    Only promote eligible students (those who meet pass percentage criteria)
                </label>
            </div>
        </div>
        
        @if($showCandidates && !empty($candidates))
            <div class="card mb-3">
                <div class="card-header">
                    <h6 class="mb-0">Promotion Candidates</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="text-center">
                                <h5 class="text-primary">{{ $candidates['total_count'] }}</h5>
                                <small class="text-muted">Total Students</small>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="text-center">
                                <h5 class="text-success">{{ $candidates['eligible_count'] }}</h5>
                                <small class="text-muted">Eligible Students</small>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="text-center">
                                <h5 class="text-warning">{{ $candidates['ineligible_count'] }}</h5>
                                <small class="text-muted">Ineligible Students</small>
                            </div>
                        </div>
                    </div>
                    
                    @if($onlyEligible && $candidates['eligible_count'] == 0)
                        <div class="alert alert-warning mt-3">
                            <i class="fas fa-exclamation-triangle me-2"></i>
                            No students meet the promotion criteria in this class.
                        </div>
                    @endif
                </div>
            </div>
        @endif
        
        <div class="d-flex justify-content-end">
            <button type="button" wire:click="confirmPromotion" class="btn btn-primary" 
                    @if(!$fromClassId || !$toClassId || ($onlyEligible && isset($candidates['eligible_count']) && $candidates['eligible_count'] == 0)) disabled @endif>
                <i class="fas fa-arrow-up me-2"></i>Promote Students
            </button>
        </div>
</div>