<div>
        <div class="row">
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="studentSearch" class="form-label">Search Student</label>
                    <input wire:model.live="studentSearch" type="text" id="studentSearch" class="form-control" 
                           placeholder="Search by name or student ID...">
                    
                    @if($studentSearch && $searchResults->count() > 0)
                        <div class="mt-2 border rounded" style="max-height: 200px; overflow-y: auto;">
                            @foreach($searchResults as $student)
                                <div class="p-2 border-bottom cursor-pointer hover-bg-light" 
                                     wire:click="selectStudent({{ $student->id }})" 
                                     style="cursor: pointer;"
                                     onmouseover="this.style.backgroundColor='#f8f9fa'" 
                                     onmouseout="this.style.backgroundColor='white'">
                                    <strong>{{ $student->name }}</strong> ({{ $student->student_id }})
                                    @if($student->batch && $student->batch->schoolClass)
                                        <br><small class="text-muted">{{ $student->batch->schoolClass->display_name }} - {{ $student->batch->name }}</small>
                                    @endif
                                </div>
                            @endforeach
                        </div>
                    @endif
                </div>
                <div class="mb-3">
                    <label for="studentId" class="form-label">Or Select from Dropdown</label>
                    <select wire:model.live="studentId" id="studentId" class="form-select">
                        <option value="">Select student to promote</option>
                        @foreach($students as $student)
                            <option value="{{ $student->id }}">
                                {{ $student->name }} ({{ $student->student_id }})
                            </option>
                        @endforeach
                    </select>
                    @error('studentId') <div class="text-danger">{{ $message }}</div> @enderror
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="toClassId" class="form-label">To Class</label>
                    <select wire:model.live="toClassId" id="toClassId" class="form-select">
                        <option value="">Select destination class</option>
                        @foreach($classes as $class)
                            <option value="{{ $class->id }}">{{ $class->display_name }}</option>
                        @endforeach
                    </select>
                    @error('toClassId') <div class="text-danger">{{ $message }}</div> @enderror
                </div>
                
                <div class="mb-3">
                    <div class="form-check form-switch">
                        <input wire:model.live="createNewBatch" class="form-check-input" type="checkbox" id="createNewBatch">
                        <label class="form-check-label" for="createNewBatch">
                            Create new batch
                        </label>
                    </div>
                </div>
                
                @if(!$createNewBatch && !empty($availableBatches))
                    <div class="mb-3">
                        <label for="toBatchId" class="form-label">Select Batch</label>
                        <select wire:model="toBatchId" id="toBatchId" class="form-select">
                            <option value="">Select destination batch</option>
                            @foreach($availableBatches as $batch)
                                <option value="{{ $batch->id }}">
                                    {{ $batch->name }} ({{ $batch->current_students }}/{{ $batch->capacity }})
                                </option>
                            @endforeach
                        </select>
                        @error('toBatchId') <div class="text-danger">{{ $message }}</div> @enderror
                    </div>
                @endif
            </div>
        </div>
        
        @if($demotionWarning)
            <div class="alert alert-warning mb-3">
                <i class="fas fa-exclamation-triangle me-2"></i>{{ $demotionWarning }}
            </div>
        @endif
        
        @if($selectedStudent)
            <div class="card mb-3">
                <div class="card-header">
                    <h6 class="mb-0">Student Information</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <p><strong>Name:</strong> {{ $selectedStudent->name }}</p>
                            <p><strong>Student ID:</strong> {{ $selectedStudent->student_id }}</p>
                        </div>
                        <div class="col-md-6">
                            <p><strong>Current Class:</strong> 
                                @if($selectedStudent->batch && $selectedStudent->batch->schoolClass)
                                    {{ $selectedStudent->batch->schoolClass->display_name }}
                                @else
                                    Not assigned
                                @endif
                            </p>
                            <p><strong>Current Batch:</strong> 
                                @if($selectedStudent->batch)
                                    {{ $selectedStudent->batch->name }}
                                @else
                                    Not assigned
                                @endif
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        @endif
        
        <div class="d-flex justify-content-end">
            <button type="button" wire:click="confirmPromotion" class="btn btn-primary" 
                    @if(!$studentId || !$toClassId || (!$createNewBatch && !$toBatchId)) disabled @endif>
                <i class="fas fa-arrow-up me-2"></i>Promote Student
            </button>
        </div>
</div>