<div>
    <!-- Filter Form -->
    <div class="row mb-4">
        <div class="col-md-3">
            <label for="year" class="form-label">Academic Year</label>
            <select wire:model="year" class="form-select" id="year">
                <option value="">Select Year</option>
                @foreach($years as $yearOption)
                    <option value="{{ $yearOption }}">{{ $yearOption }}/{{ $yearOption + 1 }}</option>
                @endforeach
            </select>
        </div>
        <div class="col-md-3">
            <label for="classId" class="form-label">Class</label>
            <select wire:model.live="classId" class="form-select" id="classId">
                <option value="">Select Class</option>
                @foreach($classes as $class)
                    <option value="{{ $class->id }}">{{ $class->display_name }}</option>
                @endforeach
            </select>
        </div>
        <div class="col-md-3">
            <label for="batchId" class="form-label">Batch (Optional)</label>
            <select wire:model="batchId" class="form-select" id="batchId">
                <option value="">All Batches</option>
                @foreach($batches as $batch)
                    <option value="{{ $batch->id }}">{{ $batch->name }}</option>
                @endforeach
            </select>
        </div>
        <div class="col-md-3">
            <label class="form-label">&nbsp;</label>
            <button wire:click="loadAnnualResults"
                    class="btn btn-primary w-100 d-flex align-items-center justify-content-center">
                <i class="fas fa-search me-2"></i>Load
            </button>
        </div>
    </div>

    @if(!empty($annualData))
        <!-- Class Info Header -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="card bg-light">
                    <div class="card-body">
                        <h5>{{ $selectedClass->display_name }}@if($selectedBatch)
                                - {{ $selectedBatch->name }}
                            @endif</h5>
                        <p class="mb-1"><strong>Academic Year:</strong> {{ $selectedYear }}/{{ $selectedYear + 1 }}</p>
                        <p class="mb-0"><strong>Total Students:</strong> {{ $classStats['total_students'] ?? 0 }}</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Chart and Summary Section -->
        <div class="row mb-4">
            <!-- Chart Column -->
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h6 class="mb-0">Class Performance Chart</h6>
                    </div>
                    <div class="card-body">
                        <canvas id="classGradeChart" width="400" height="300" wire:ignore></canvas>
                    </div>
                </div>
            </div>

            <!-- Summary Column -->
            <div class="col-md-6">
                <!-- Class Summary Cards -->
                <div class="row mb-3">
                    <div class="col-6">
                        <div class="card text-center bg-primary">
                            <div class="card-body">
                                <h5 class="card-title text-white">Class Average</h5>
                                <h3 class="text-white">{{ $classStats['class_average'] ?? 0 }}%</h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="card text-center bg-success">
                            <div class="card-body">
                                <h5 class="card-title text-white">Passed</h5>
                                <h3 class="text-white">{{ $classStats['passed_students'] ?? 0 }}</h3>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="col-6">
                        <div class="card text-center bg-info">
                            <div class="card-body">
                                <h5 class="card-title text-white">Sessions</h5>
                                <h3 class="text-white">{{ $classStats['total_sessions'] ?? 0 }}</h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="card text-center bg-danger">
                            <div class="card-body">
                                <h5 class="card-title text-white">Failed</h5>
                                <h3 class="text-white">{{ $classStats['failed_students'] ?? 0 }}</h3>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Grade Distribution -->
                <div class="card">
                    <div class="card-header">
                        <h6 class="mb-0">Class Grade Distribution</h6>
                    </div>
                    <div class="card-body">
                        <div class="row text-center g-2">
                            @foreach(['A', 'B', 'C', 'D', 'E', 'F'] as $grade)
                                <div class="col-6 col-sm-4 col-md-2">
                                    <div
                                        class="badge bg-{{ $grade === 'A' ? 'success' : ($grade === 'F' ? 'danger' : 'secondary') }} p-3 w-100 d-flex flex-column align-items-center justify-content-center"
                                        style="min-height: 60px;">
                                        <div class="fw-bold">{{ $grade }}</div>
                                        <div class="h6 mb-0">{{ $classStats['grade_distribution'][$grade] ?? 0 }}</div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Student Results Table -->
        <div class="row">
            <div class="col-12">
                <div class="card border-0">
                    <div class="card-header border-0 p-2 mb-2 d-flex justify-content-between align-items-center">
                        <h6 class="mb-0">Student Annual Results</h6>
                        <button type="button" class="btn btn-outline-info btn-sm" data-bs-toggle="modal"
                                data-bs-target="#calculationHelpModal">
                            <i class="fas fa-question-circle"></i> Help
                        </button>
                    </div>
                    <div class="card-body p-0">
                        <!-- Desktop View -->
                        <div class="d-none d-lg-block">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped text-center align-middle">
                                    <thead class="table-dark">
                                    <tr>
                                        <th rowspan="2">Position</th>
                                        <th rowspan="2">Student Name</th>
                                        @foreach($sessions as $session)
                                            <th colspan="2" class="text-center">{{ $session->name }}</th>
                                        @endforeach
                                        @php
                                            $maxAnnualScore = !empty($annualData) ? $annualData[0]['total_possible_score'] ?? 0 : 0;
                                        @endphp
                                        <th rowspan="2">Annual Total ({{ $maxAnnualScore }})</th>
                                        <th rowspan="2">Total Average @if(!empty($annualData))
                                                ({{ 100 * count($subjects) }})
                                            @endif</th>
                                        <th rowspan="2">Annual Avg % (100%)</th>
                                        <th rowspan="2">Comment</th>
                                    </tr>
                                    <tr>
                                        @foreach($sessions as $session)
                                            @php
                                                $maxSessionScore = !empty($annualData) ? $annualData[0]['sessions'][$session->id]['total_possible_score'] ?? 0 : 0;
                                            @endphp
                                            <th>Total ({{ $maxSessionScore }})</th>
                                            <th>Average</th>
                                        @endforeach
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($annualData as $index => $studentData)
                                        <tr>
                                            <td><strong>{{ $studentData['position_suffix'] ?? ($index + 1) }}</strong>
                                            </td>
                                            <td class="text-start"><strong>{{ $studentData['student']->name }}</strong>
                                            </td>
                                            @foreach($sessions as $session)
                                                @php
                                                    $sessionData = $studentData['sessions'][$session->id] ?? null;
                                                @endphp
                                                <td>{{ $sessionData['grand_total'] ?? 0 }}</td>
                                                <td>{{ $sessionData['average'] ?? 0 }}</td>
                                            @endforeach
                                            <td><strong>{{ $studentData['annual_grand_total'] }}</strong></td>
                                            <td><strong>{{ $studentData['total_average'] }}</strong></td>
                                            <td><strong>{{ $studentData['annual_average'] }}%</strong></td>
                                            @php
                                                $passPercentage = settings('annual_pass_percentage', 50);
                                                $comment = $studentData['annual_average'] >= $passPercentage ? 'Promoted' : 'Demoted';
                                            @endphp
                                            <td><span
                                                    class="badge bg-{{ $studentData['annual_average'] >= $passPercentage ? 'success' : 'danger' }}">{{ $comment }}</span>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <!-- Mobile View -->
                        <div class="d-lg-none">
                            @foreach($annualData as $index => $studentData)
                                <div class="card mb-2">
                                    <div class="card-header p-0">
                                        <div class="d-flex">
                                            <div class="flex-grow-1 p-3" data-bs-toggle="collapse"
                                                 data-bs-target="#student{{ $index }}" style="cursor: pointer;">
                                                <div class="d-flex justify-content-between align-items-center">
                                                    <div>
                                                        <span
                                                            class="badge bg-light text-dark me-2">{{ $studentData['position_suffix'] ?? ($index + 1) }}</span>
                                                        <strong>{{ $studentData['student']->name }}</strong>
                                                    </div>
                                                    <div>
                                                        <i class="fas fa-chevron-down text-muted"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="collapse" id="student{{ $index }}">
                                        <div class="card-body">
                                            <div class="mb-3">
                                                <div class="d-flex flex-wrap gap-2 mb-2">
                                                    <span
                                                        class="badge bg-primary">{{ $studentData['annual_average'] }}%</span>
                                                    @php
                                                        $passPercentage = settings('annual_pass_percentage', 50);
                                                        $comment = $studentData['annual_average'] >= $passPercentage ? 'Promoted' : 'Demoted';
                                                    @endphp
                                                    <span
                                                        class="badge bg-{{ $studentData['annual_average'] >= $passPercentage ? 'success' : 'danger' }}">{{ $comment }}</span>
                                                </div>
                                            </div>

                                            @foreach($sessions as $session)
                                                @php
                                                    $sessionData = $studentData['sessions'][$session->id] ?? null;
                                                @endphp
                                                <div class="mb-3">
                                                    <h6>{{ $session->name }}</h6>
                                                    <div class="row">
                                                        <div class="col-6">
                                                            <strong>Total:</strong> {{ $sessionData['grand_total'] ?? 0 }}
                                                        </div>
                                                        <div class="col-6">
                                                            <strong>Average:</strong> {{ $sessionData['average'] ?? 0 }}
                                                        </div>
                                                    </div>
                                                    @if(!$loop->last)
                                                        <hr class="my-2">
                                                    @endif
                                                </div>
                                            @endforeach
                                            <hr>
                                            <div class="row">
                                                <div class="col-6">
                                                    <strong>Annual
                                                        Total:</strong> {{ $studentData['annual_grand_total'] }}
                                                </div>
                                                <div class="col-6">
                                                    <strong>Total Average:</strong> {{ $studentData['total_average'] }}
                                                </div>
                                                <div class="col-12 mt-2">
                                                    <strong>Annual Avg %:</strong> {{ $studentData['annual_average'] }}%
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>

                        <!-- Teachers and Timestamp -->
                        @if(settings('show_class_teachers_online', true) || settings('show_timestamp', true))
                            <div class="mt-3">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="row">
                                            @if(settings('show_class_teachers_online', true))
                                                <div class="col-md-6">
                                                    <h6>Class Teachers:</h6>
                                                    @if($selectedClass && $selectedClass->teachers && $selectedClass->teachers->count() > 0)
                                                        @foreach($selectedClass->teachers as $teacher)
                                                            <span
                                                                class="badge bg-primary me-1">{{ $teacher->name }}</span>
                                                        @endforeach
                                                    @else
                                                        <span class="text-muted">No teachers assigned</span>
                                                    @endif
                                                </div>
                                            @endif
                                            @if(settings('show_timestamp', true))
                                                <div class="col-md-6 text-end">
                                                    <small class="text-muted">Generated
                                                        on: {{ now()->format('M d, Y \a\t h:i A') }}</small>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif

                        <!-- Print Button -->
                        <div class="mt-3 text-center">
                            <button onclick="printClassAnnualResult()" class="btn btn-success">
                                <i class="fas fa-print"></i> Print Class Annual Result
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif

    <!-- Calculation Help Modal -->
    <div class="modal fade help-modal" id="calculationHelpModal" tabindex="-1"
         aria-labelledby="calculationHelpModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header text-light">
                    <h5 class="modal-title text-light" id="calculationHelpModalLabel">Annual Results Calculation
                        Guide</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body help-modal-body">
                    <div class="row">
                        <div class="col-12">
                            <h6 class="text-primary">Session-Level Calculations</h6>
                            <ul class="list-unstyled">
                                <li><strong>Session Total:</strong> Sum of all subject scores for that session</li>
                                <li><strong>Session Average:</strong> Session Total ÷ Number of Subjects</li>
                                <li><strong>Maximum Session Total:</strong> 100 × Number of Subjects</li>
                            </ul>

                            <h6 class="text-primary mt-4">Annual-Level Calculations</h6>
                            <ul class="list-unstyled">
                                <li><strong>Annual Total:</strong> Sum of all session totals across the academic year
                                </li>
                                <li><strong>Maximum Annual Total:</strong> 100 × Number of Subjects × Number of Sessions
                                </li>
                                <li><strong>Total Average:</strong> Sum of subject averages across all sessions<br>
                                    <small class="text-muted">For each subject: (Sum of session scores ÷ Number of
                                        sessions), then sum all subject averages</small>
                                </li>
                                <li><strong>Maximum Total Average:</strong> 100 × Number of Subjects</li>
                                <li><strong>Annual Avg %:</strong> (Annual Total ÷ Maximum Annual Total) × 100</li>
                                <li><strong>Maximum Annual Avg %:</strong> 100%</li>
                            </ul>

                            <h6 class="text-primary mt-4">Example Calculation</h6>
                            <div class="bg-light p-3 rounded">
                                <p><strong>Scenario:</strong> 3 subjects, 2 sessions</p>
                                <p><strong>Student scores:</strong></p>
                                <ul>
                                    <li>Session 1: Math(80), English(70), Science(90) → Total: 240, Average: 80</li>
                                    <li>Session 2: Math(85), English(75), Science(95) → Total: 255, Average: 85</li>
                                </ul>
                                <p><strong>Annual Calculations:</strong></p>
                                <ul>
                                    <li>Annual Total: 240 + 255 = 495 (Max: 600)</li>
                                    <li>Total Average: Math(82.5) + English(72.5) + Science(92.5) = 247.5 (Max: 300)
                                    </li>
                                    <li>Annual Avg %: (495 ÷ 600) × 100 = 82.5%</li>
                                </ul>
                            </div>

                            <h6 class="text-primary mt-4">Promotion Criteria</h6>
                            <p>Students are promoted if their Annual Avg % meets or exceeds the school's annual pass
                                percentage (configurable in settings).</p>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('livewire:initialized', () => {
        Livewire.on('initClassGradeChart', (data) => {
            setTimeout(() => {
                if (typeof initGradeChart === 'function') {
                    initGradeChart('classGradeChart', data[0].labels, data[0].data, 'Class Performance');
                }
            }, 100);
        });
    });

    function printClassAnnualResult() {
        @this.
        call('getPrintUrl').then(url => {
            if (url) {
                window.open(url, '_blank', 'width=1200,height=800,scrollbars=yes,resizable=yes');
            }
        });
    }


</script>
