<div>
    <form wire:submit.prevent="approveResults">
        <div class="row mb-4">
            <div class="col-md-6 col-lg-3">
                <label for="selectedSession" class="form-label">Select Session</label>
                <select wire:model.live="selectedSession" class="form-select" id="selectedSession">
                    <option value="">Choose a session...</option>
                    @foreach($sessions as $session)
                        <option value="{{ $session->id }}">{{ $session->name }} ({{ $session->start_year }}/{{ $session->end_year }})</option>
                    @endforeach
                </select>
                @error('selectedSession') <div class="text-danger">{{ $message }}</div> @enderror
            </div>
            <div class="col-md-6 col-lg-3">
                <label for="selectedClass" class="form-label">Select Class</label>
                <select wire:model.live="selectedClass" class="form-select" id="selectedClass" {{ !$selectedSession ? 'disabled' : '' }}>
                    <option value="">Choose a class...</option>
                    @foreach($classes as $class)
                        <option value="{{ $class->id }}">{{ $class->display_name }}</option>
                    @endforeach
                </select>
                @error('selectedClass') <div class="text-danger">{{ $message }}</div> @enderror
            </div>
            <div class="col-md-6 col-lg-3">
                <label for="selectedBatch" class="form-label">Select Batch</label>
                <select wire:model.live="selectedBatch" class="form-select" id="selectedBatch" {{ !$selectedClass ? 'disabled' : '' }}>
                    <option value="">Choose a batch...</option>
                    @foreach($batches as $batch)
                        <option value="{{ $batch->id }}">{{ $batch->name }}</option>
                    @endforeach
                </select>
                @error('selectedBatch') <div class="text-danger">{{ $message }}</div> @enderror
            </div>
            <div class="col-md-6 col-lg-3">
                @if(!empty($selectedStudents) && $selectedSession)
                    <label class="form-label">&nbsp;</label>
                    <button type="button" 
                            wire:click="loadStudentResults" 
                            class="btn btn-primary btn-lg d-block"
                            wire:loading.attr="disabled"
                            wire:target="loadStudentResults">
                        <span wire:loading.remove wire:target="loadStudentResults">
                            <i class="fas fa-sync me-2"></i>Load Results
                        </span>
                        <span wire:loading wire:target="loadStudentResults">
                            <i class="fas fa-spinner fa-spin me-2"></i>Loading...
                        </span>
                    </button>
                @endif
            </div>
        </div>
        
        @if($selectedSession && $selectedClass && $selectedBatch)
            <div class="row mb-4">
                <div class="col-md-12">
                    <label class="form-label">Select Students</label>
                    <div class="border rounded p-3" style="max-height: 300px; overflow-y: auto;">
                        @if(count($students) > 0)
                            @foreach($students as $student)
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" wire:model.live="selectedStudents" wire:change="loadStudentResults" value="{{ $student->id }}" id="student_{{ $student->id }}">
                                    <label class="form-check-label" for="student_{{ $student->id }}">
                                        {{ $student->name }} ({{ $student->student_id }})
                                    </label>
                                </div>
                            @endforeach
                        @else
                            <div class="alert alert-info mb-0">
                                <i class="fas fa-info-circle me-2"></i>
                                <strong>No students meet the search criteria.</strong><br>
                                It appears all student results for the selected class, batch, and session have been approved.
                            </div>
                        @endif
                    </div>
                    <small class="text-muted">Select multiple students by checking boxes (excludes students with already approved results)</small>
                    @error('selectedStudents') <div class="text-danger">{{ $message }}</div> @enderror
                </div>
            </div>
        @endif

        @if(!empty($studentResults))
            <div class="card mb-5">
                <div class="card-header">
                    <h5 class="mb-0">Student Results Summary</h5>
                </div>
                <div class="card-body">
                    @foreach($studentResults as $studentId => $data)
                        <div class="mb-3">
                            <h6>{{ $data['student']->name }}</h6>
                            <div class="table-responsive">
                                <table class="table table-sm table-bordered">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Subject</th>
                                            <th>CA Score</th>
                                            <th>Exam Score</th>
                                            <th>Total</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($data['results'] as $result)
                                            <tr>
                                                <td>{{ $result['subject']->display_name }}</td>
                                                <td>{{ $result['ca_score'] }}</td>
                                                <td>{{ $result['exam_score'] }}</td>
                                                <td><strong>{{ $result['total_score'] }}</strong></td>
                                            </tr>
                                        @endforeach
                                        <tr class="table-info">
                                            <td colspan="3"><strong>Grand Total</strong></td>
                                            <td><strong>{{ $data['total'] }}</strong></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>

            <div class="row">
                <div class="col-md-6 mb-4">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0">Affective Traits</h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Punctuality</label>
                                    <input type="number" wire:model="punctuality" class="form-control" min="0" max="5" step="0.1">
                                    @error('punctuality') <div class="text-danger small">{{ $message }}</div> @enderror
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Mental Alertness</label>
                                    <input type="number" wire:model="mental_alertness" class="form-control" min="0" max="5" step="0.1">
                                    @error('mental_alertness') <div class="text-danger small">{{ $message }}</div> @enderror
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Attentiveness</label>
                                    <input type="number" wire:model="attentiveness" class="form-control" min="0" max="5" step="0.1">
                                    @error('attentiveness') <div class="text-danger small">{{ $message }}</div> @enderror
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Respect</label>
                                    <input type="number" wire:model="respect" class="form-control" min="0" max="5" step="0.1">
                                    @error('respect') <div class="text-danger small">{{ $message }}</div> @enderror
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Neatness</label>
                                    <input type="number" wire:model="neatness" class="form-control" min="0" max="5" step="0.1">
                                    @error('neatness') <div class="text-danger small">{{ $message }}</div> @enderror
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Politeness</label>
                                    <input type="number" wire:model="politeness" class="form-control" min="0" max="5" step="0.1">
                                    @error('politeness') <div class="text-danger small">{{ $message }}</div> @enderror
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Honesty</label>
                                    <input type="number" wire:model="honesty" class="form-control" min="0" max="5" step="0.1">
                                    @error('honesty') <div class="text-danger small">{{ $message }}</div> @enderror
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Relationship with Peers</label>
                                    <input type="number" wire:model="relationship_with_peers" class="form-control" min="0" max="5" step="0.1">
                                    @error('relationship_with_peers') <div class="text-danger small">{{ $message }}</div> @enderror
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Attitude to School</label>
                                    <input type="number" wire:model="attitude_to_school" class="form-control" min="0" max="5" step="0.1">
                                    @error('attitude_to_school') <div class="text-danger small">{{ $message }}</div> @enderror
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Teamwork</label>
                                    <input type="number" wire:model="teamwork" class="form-control" min="0" max="5" step="0.1">
                                    @error('teamwork') <div class="text-danger small">{{ $message }}</div> @enderror
                                </div>
                                <div class="col-12 mb-3">
                                    <label class="form-label">Completes School Work Promptly</label>
                                    <input type="number" wire:model="completes_school_work_promptly" class="form-control" min="0" max="5" step="0.1">
                                    @error('completes_school_work_promptly') <div class="text-danger small">{{ $message }}</div> @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0">Psychomotor Skills</h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Reading</label>
                                    <input type="number" wire:model="reading" class="form-control" min="0" max="5" step="0.1">
                                    @error('reading') <div class="text-danger small">{{ $message }}</div> @enderror
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Verbal Fluency/Diction</label>
                                    <input type="number" wire:model="verbal_fluency_diction" class="form-control" min="0" max="5" step="0.1">
                                    @error('verbal_fluency_diction') <div class="text-danger small">{{ $message }}</div> @enderror
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Handwriting</label>
                                    <input type="number" wire:model="handwriting" class="form-control" min="0" max="5" step="0.1">
                                    @error('handwriting') <div class="text-danger small">{{ $message }}</div> @enderror
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Musical Skills</label>
                                    <input type="number" wire:model="musical_skills" class="form-control" min="0" max="5" step="0.1">
                                    @error('musical_skills') <div class="text-danger small">{{ $message }}</div> @enderror
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Creative Arts</label>
                                    <input type="number" wire:model="creative_arts" class="form-control" min="0" max="5" step="0.1">
                                    @error('creative_arts') <div class="text-danger small">{{ $message }}</div> @enderror
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Physical Education</label>
                                    <input type="number" wire:model="physical_education" class="form-control" min="0" max="5" step="0.1">
                                    @error('physical_education') <div class="text-danger small">{{ $message }}</div> @enderror
                                </div>
                                <div class="col-12 mb-3">
                                    <label class="form-label">General Reasoning</label>
                                    <input type="number" wire:model="general_reasoning" class="form-control" min="0" max="5" step="0.1">
                                    @error('general_reasoning') <div class="text-danger small">{{ $message }}</div> @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card mt-3">
                <div class="card-header">
                    <h5 class="mb-0">Principal/Head Teacher's Remarks</h5>
                </div>
                <div class="card-body">
                    <textarea wire:model="principal_remarks" class="form-control" rows="4" placeholder="Enter remarks..."></textarea>
                    @error('principal_remarks') <div class="text-danger">{{ $message }}</div> @enderror
                </div>
            </div>

            <div class="d-flex justify-content-end mt-4">
                <button type="submit" 
                        class="btn btn-success btn-lg"
                        wire:loading.attr="disabled"
                        wire:target="approveResults">
                    <span wire:loading.remove wire:target="approveResults">
                        <i class="fas fa-check me-2"></i>Approve Results
                    </span>
                    <span wire:loading wire:target="approveResults">
                        <i class="fas fa-spinner fa-spin me-2"></i>Processing...
                    </span>
                </button>
            </div>
        @endif
    </form>
</div>

