<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title mb-0">Master List</h4>
                </div>
                <div class="card-body">
                    <div class="row mb-4 align-items-center">
                        <div class="col-md-6 col-lg-3">
                            <label for="sessionSelect" class="form-label">Select Session</label>
                            <select wire:model.live="sessionId" id="sessionSelect" class="form-select">
                                <option value="">Choose Session...</option>
                                @foreach($sessions as $session)
                                    <option value="{{ $session->id }}">{{ $session->start_year }}/{{ $session->end_year }} - {{ $session->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-6 col-lg-3">
                            <label for="classSelect" class="form-label">Select Class</label>
                            <select wire:model.live="classId" id="classSelect" class="form-select">
                                <option value="">Choose Class...</option>
                                @foreach($classes as $class)
                                    <option value="{{ $class->id }}">{{ $class->display_name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-12 col-lg-3">
                            <label for="batchSelect" class="form-label">Select Batch (Optional)</label>
                            <select wire:model.live="batchId" id="batchSelect" class="form-select" {{ !$classId ? 'disabled' : '' }}>
                                <option value="">All Batches</option>
                                @foreach($batches as $batch)
                                    <option value="{{ $batch->id }}">{{ $batch->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-12 col-lg-3 d-lg-flex align-items-end">
                            <button wire:click="loadMasterList" 
                                    class="btn {{ !$sessionId || !$classId ? 'btn-secondary' : 'btn-primary' }} w-100" 
                                    wire:loading.attr="disabled"
                                    {{ !$sessionId || !$classId ? 'disabled' : '' }}>
                                <span wire:loading.remove wire:target="loadMasterList">
                                    <i class="fas fa-list-alt me-2"></i>Load
                                </span>
                                <span wire:loading wire:target="loadMasterList">
                                    <i class="fas fa-spinner fa-spin me-2"></i>Loading...
                                </span>
                            </button>
                        </div>
                    </div>

                    @if($masterListData)
                        <div class="mb-3">
                            <h5>{{ $masterListData['session']->name }} - {{ $masterListData['class']->display_name }}@if($masterListData['batch']) - {{ $masterListData['batch']->name }}@else (All Batches)@endif</h5>
                        </div>
                        
                        @if(empty($masterListData['masterListData']) || count($masterListData['masterListData']) == 0)
                            <div class="card border-warning">
                                <div class="card-body text-center py-5">
                                    <i class="fas fa-users-slash fa-3x text-warning mb-3"></i>
                                    <h5 class="card-title text-warning">No Students Found</h5>
                                    <p class="card-text text-muted">
                                        There are no students in the selected class
                                        @if($masterListData['batch'])
                                            and batch ({{ $masterListData['batch']->name }})
                                        @endif
                                        for the {{ $masterListData['session']->name }} session.
                                    </p>
                                    <p class="card-text">
                                        <small class="text-muted">
                                            Please check if students are assigned to 
                                            @if($masterListData['batch'])
                                                this batch or try selecting "All Batches".
                                            @else
                                                this class or try a different class/session.
                                            @endif
                                        </small>
                                    </p>
                                </div>
                            </div>
                        @else

                        <!-- Desktop Table -->
                        <div class="d-none d-lg-block">
                            <div class="text-center mb-4">
                                <img src="{{ asset('images/rosa-mys-logo.png') }}" alt="School Logo" class="mb-3" style="height: 80px;">
                                <h4 class="fw-bold">{{ $masterListData['school_info']['name'] }} - Termly Master Sheet</h4>
                                @if($masterListData['school_info']['address'])
                                <p class="mb-1">{{ $masterListData['school_info']['address'] }}</p>
                                @endif
                                @if($masterListData['school_info']['phone_1'] || $masterListData['school_info']['phone_2'])
                                <p class="mb-1">
                                    Phone: {{ $masterListData['school_info']['phone_1'] }}
                                    @if($masterListData['school_info']['phone_1'] && $masterListData['school_info']['phone_2']) , @endif
                                    {{ $masterListData['school_info']['phone_2'] }}
                                </p>
                                @endif
                                @if($masterListData['school_info']['email'] || $masterListData['school_info']['website'])
                                <p class="mb-0">
                                    @if($masterListData['school_info']['email'])
                                        Email: {{ $masterListData['school_info']['email'] }}
                                    @endif
                                    @if($masterListData['school_info']['email'] && $masterListData['school_info']['website']) | @endif
                                    @if($masterListData['school_info']['website'])
                                        Website: {{ $masterListData['school_info']['website'] }}
                                    @endif
                                </p>
                                @endif
                            </div>
                            
                            <div class="row mb-3">
                                <div class="col-md-3"><strong>Session:</strong> {{ $masterListData['session']->start_year }}/{{ $masterListData['session']->end_year }}</div>
                                <div class="col-md-3"><strong>Term:</strong> {{ $masterListData['session']->name }}</div>
                                <div class="col-md-3"><strong>Class:</strong> {{ $masterListData['class']->display_name }}@if($masterListData['batch']) - {{ $masterListData['batch']->name }}@endif</div>
                                <div class="col-md-3"><strong>Total Possible Score:</strong> {{ count($masterListData['subjects']) * 100 }}</div>
                            </div>
                            
                            <div class="table-responsive">
                                <table class="table master-list-table table-bordered">
                                    <thead>
                                        <tr>
                                            <th rowspan="2">S/N</th>
                                            <th rowspan="2">Student Name</th>
                                            <th rowspan="2">Student ID</th>
                                            @foreach($masterListData['subjects'] as $index => $subject)
                                                <th colspan="3" class="subject-header {{ $index > 0 ? 'subject-separator' : '' }}">{{ $subject->display_name }}</th>
                                            @endforeach
                                            <th rowspan="2" class="grand-total">Grand Total</th>
                                            <th rowspan="2">Average</th>
                                            <th rowspan="2" class="grade-cell">A</th>
                                            <th rowspan="2" class="grade-cell">B</th>
                                            <th rowspan="2" class="grade-cell">C</th>
                                            <th rowspan="2" class="grade-cell">D</th>
                                            <th rowspan="2" class="grade-cell">E</th>
                                            <th rowspan="2" class="grade-cell">F</th>
                                            <th rowspan="2" class="position">Position</th>
                                            <th rowspan="2">Remark</th>
                                        </tr>
                                        <tr>
                                            @foreach($masterListData['subjects'] as $index => $subject)
                                                <th class="subject-subheader {{ $index > 0 ? 'subject-separator' : '' }}">CA</th>
                                                <th class="subject-subheader">Exam</th>
                                                <th class="subject-subheader">Total</th>
                                            @endforeach
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($masterListData['masterListData'] as $index => $studentData)
                                            <tr>
                                                <td>{{ $index + 1 }}</td>
                                                <td class="student-name">{{ $studentData['student']->name }}</td>
                                                <td>{{ $studentData['student']->student_id }}</td>
                                                @foreach($masterListData['subjects'] as $index => $subject)
                                                    @php $subjectResult = $studentData['subjects'][$subject->id] ?? null; @endphp
                                                    <td class="{{ $index > 0 ? 'subject-separator' : '' }}">{{ intval($subjectResult['ca_score'] ?? 0) }}</td>
                                                    <td>{{ intval($subjectResult['exam_score'] ?? 0) }}</td>
                                                    <td class="fw-bold">{{ intval($subjectResult['total'] ?? 0) }}</td>
                                                @endforeach
                                                <td class="grand-total">{{ intval($studentData['grand_total']) }}</td>
                                                <td>{{ $studentData['average'] }}</td>
                                                <td class="grade-cell">{{ $studentData['grades']['A'] }}</td>
                                                <td class="grade-cell">{{ $studentData['grades']['B'] }}</td>
                                                <td class="grade-cell">{{ $studentData['grades']['C'] }}</td>
                                                <td class="grade-cell">{{ $studentData['grades']['D'] }}</td>
                                                <td class="grade-cell">{{ $studentData['grades']['E'] }}</td>
                                                <td class="grade-cell">{{ $studentData['grades']['F'] }}</td>
                                                <td class="position">{{ $studentData['position_suffix'] }}</td>
                                                <td>
                                                    <span class="badge {{ $studentData['remark'] === 'Pass' ? 'bg-success' : 'bg-danger' }}">
                                                        {{ $studentData['remark'] }}
                                                    </span>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="{{ 9 + (count($masterListData['subjects']) * 3) }}" class="text-center">
                                                <strong>Class Teacher(s):</strong>
                                                @if($masterListData['class']->teachers->count() > 0)
                                                    {{ $masterListData['class']->teachers->pluck('name')->join(', ') }}
                                                @else
                                                    Not Assigned
                                                @endif
                                                &nbsp;&nbsp;&nbsp;&nbsp;
                                                <strong>Generated on:</strong> {{ now()->format('F j, Y \a\t g:i A') }}
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>

                        <!-- Mobile Accordions -->
                        <div class="d-lg-none">
                            <div class="master-list-accordion">
                                @foreach($masterListData['masterListData'] as $index => $studentData)
                                    <div class="card mb-2">
                                        <div class="card-header p-0">
                                            <div class="p-3" data-bs-toggle="collapse" data-bs-target="#student{{ $index }}" style="cursor: pointer;">
                                                <div class="d-flex justify-content-between align-items-center">
                                                    <span>{{ $studentData['student']->firstname }} {{ $studentData['student']->lastname }}</span>
                                                    <div class="d-flex align-items-center">
                                                        <span class="badge bg-primary me-2">{{ $studentData['position_suffix'] }}</span>
                                                        <span class="badge {{ $studentData['remark'] === 'Pass' ? 'bg-success' : 'bg-danger' }} me-2">
                                                            {{ $studentData['remark'] }}
                                                        </span>
                                                        <i class="fas fa-chevron-down text-muted"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="collapse" id="student{{ $index }}">
                                            <div class="card-body">
                                                <div class="student-summary">
                                                    <div class="row">
                                                        <div class="col-6">
                                                            <strong>Grand Total:</strong> {{ $studentData['grand_total'] }}
                                                        </div>
                                                        <div class="col-6">
                                                            <strong>Average:</strong> {{ $studentData['average'] }}
                                                        </div>
                                                    </div>
                                                    
                                                    <div class="row">
                                                        <div class="col-12">
                                                            <strong>Grades:</strong>
                                                            <div class="grades-summary mt-2">
                                                                <span class="grade-badge">A: {{ $studentData['grades']['A'] }}</span>
                                                                <span class="grade-badge">B: {{ $studentData['grades']['B'] }}</span>
                                                                <span class="grade-badge">C: {{ $studentData['grades']['C'] }}</span>
                                                                <span class="grade-badge">D: {{ $studentData['grades']['D'] }}</span>
                                                                <span class="grade-badge">E: {{ $studentData['grades']['E'] }}</span>
                                                                <span class="grade-badge">F: {{ $studentData['grades']['F'] }}</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="table-responsive">
                                                    <table class="table table-sm">
                                                        <thead>
                                                            <tr>
                                                                <th>Subject</th>
                                                                <th>CA</th>
                                                                <th>Exam</th>
                                                                <th>Total</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            @foreach($masterListData['subjects'] as $subject)
                                                                @php $subjectResult = $studentData['subjects'][$subject->id] ?? null; @endphp
                                                                <tr>
                                                                    <td>{{ $subject->display_name }}</td>
                                                                    <td>{{ $subjectResult['ca_score'] ?? 0 }}</td>
                                                                    <td>{{ $subjectResult['exam_score'] ?? 0 }}</td>
                                                                    <td class="fw-bold">{{ $subjectResult['total'] ?? 0 }}</td>
                                                                </tr>
                                                            @endforeach
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                        
                            <!-- Print Button -->
                            <div class="text-center mt-4">
                                <button onclick="window.open('{{ $this->getPrintUrl() }}', '_blank', 'width=1200,height=800')" 
                                        class="btn btn-primary btn-lg px-4 py-2">
                                    <i class="fas fa-print me-2"></i>Print Master List
                                </button>
                            </div>
                        @endif
                    @else
                        <div class="text-center py-5">
                            <i class="fas fa-chart-line fa-3x text-muted mb-3"></i>
                            <p class="text-muted">Select a session and class to view the master list</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>