<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title mb-0">
                        <i class="fas fa-upload me-2"></i>
                        Offline Results Upload
                    </h4>
                </div>
                <div class="card-body">
                    @if(!$uploadResults)
                    <form wire:submit="uploadResults">
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label for="selectedSession" class="form-label">Session</label>
                                <select wire:model.live="selectedSession" class="form-select" id="selectedSession">
                                    <option value="">Select Session</option>
                                    @foreach($sessions as $session)
                                        <option value="{{ $session->id }}">{{ $session->name }} ({{ $session->start_year }}/{{ $session->end_year }})</option>
                                    @endforeach
                                </select>
                                @error('selectedSession') <div class="text-danger">{{ $message }}</div> @enderror
                            </div>
                            
                            <div class="col-md-4 mb-3">
                                <label for="selectedClass" class="form-label">Class</label>
                                <select wire:model.live="selectedClass" class="form-select" id="selectedClass">
                                    <option value="">Select Class</option>
                                    @foreach($classes as $class)
                                        <option value="{{ $class->id }}">{{ $class->alias ?: $class->name }}</option>
                                    @endforeach
                                </select>
                                @error('selectedClass') <div class="text-danger">{{ $message }}</div> @enderror
                            </div>
                            
                            <div class="col-md-4 mb-3">
                                <label for="selectedBatch" class="form-label">Batch</label>
                                <select wire:model.live="selectedBatch" class="form-select" id="selectedBatch">
                                    <option value="">Select Batch</option>
                                    @foreach($batches as $batch)
                                        <option value="{{ $batch->id }}">{{ $batch->name }}</option>
                                    @endforeach
                                </select>
                                @error('selectedBatch') <div class="text-danger">{{ $message }}</div> @enderror
                            </div>
                        </div>
                        
                        <div class="row mb-4">
                            <div class="col-12">
                                <div class="d-flex gap-2 flex-wrap">
                                    <button type="button" wire:click="downloadTemplate" 
                                            class="btn btn-outline-primary"
                                            @if(!$selectedClass || !$selectedBatch || !$selectedSession) disabled @endif>
                                        <i class="fas fa-download me-2"></i>
                                        Download Template
                                    </button>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="uploadFile" class="form-label">Upload Excel File</label>
                                <input type="file" wire:model="uploadFile" class="form-control" id="uploadFile" 
                                       accept=".xlsx,.xls">
                                <div wire:loading wire:target="uploadFile" class="text-info mt-2">
                                    <i class="fas fa-spinner fa-spin me-2"></i>Processing file...
                                </div>
                                @error('uploadFile') <div class="text-danger">{{ $message }}</div> @enderror
                            </div>
                        </div>
                        
                        @if($isUploading)
                        <div class="row mb-3">
                            <div class="col-12">
                                <div class="progress">
                                    <div class="progress-bar progress-bar-striped progress-bar-animated" 
                                         role="progressbar" 
                                         style="width: {{ $uploadProgress }}%"
                                         aria-valuenow="{{ $uploadProgress }}" 
                                         aria-valuemin="0" 
                                         aria-valuemax="100">
                                        {{ $uploadProgress }}%
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endif
                        
                        <div class="row">
                            <div class="col-12">
                                <button type="button" wire:click="processUpload" class="btn btn-primary" 
                                        wire:loading.attr="disabled" wire:target="uploadFile,processUpload"
                                        @if($isUploading || !$selectedClass || !$selectedBatch || !$selectedSession || !$uploadFile) disabled @endif>
                                    <span wire:loading.remove wire:target="uploadFile,processUpload">
                                        <i class="fas fa-upload me-2"></i>
                                        @if($isUploading) Uploading... @else Upload Results @endif
                                    </span>
                                    <span wire:loading wire:target="uploadFile">
                                        <i class="fas fa-spinner fa-spin me-2"></i>Processing file...
                                    </span>
                                    <span wire:loading wire:target="processUpload">
                                        <i class="fas fa-spinner fa-spin me-2"></i>Uploading...
                                    </span>
                                </button>
                            </div>
                        </div>
                    </form>
                    @else
                    <!-- Upload Results Summary -->
                    <div class="alert alert-info">
                        <h5><i class="fas fa-info-circle me-2"></i>Upload Summary</h5>
                        <ul class="mb-0">
                            <li><strong>{{ $uploadResults['updated'] }}</strong> student results were updated</li>
                            <li><strong>{{ $uploadResults['ignored'] }}</strong> students were ignored (already approved results)</li>
                            @if($uploadResults['wrong_class'] > 0)
                                <li><strong>{{ $uploadResults['wrong_class'] }}</strong> students from wrong class/batch</li>
                            @endif
                            @if(count($uploadResults['errors']) > 0)
                                <li><strong>{{ count($uploadResults['errors']) }}</strong> errors occurred</li>
                            @endif
                        </ul>
                    </div>
                    
                    @if(count($uploadResults['errors']) > 0)
                    <div class="alert alert-warning">
                        <h6>Errors:</h6>
                        <ul class="mb-0">
                            @foreach($uploadResults['errors'] as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif
                    
                    <button type="button" wire:click="resetUpload" class="btn btn-secondary">
                        <i class="fas fa-redo me-2"></i>
                        Upload Another File
                    </button>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>