<div class="container-fluid">

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title mb-0">View Results</h4>
                </div>
                <div class="card-body">
                    <div class="row mb-4">
                        <div class="col-12 mb-3">
                            <label for="studentSearch" class="form-label">Search Student (Optional)</label>
                            <div class="d-flex gap-2">
                                <input wire:model.live="studentSearch" type="text" id="studentSearch"
                                       class="form-control"
                                       placeholder="Search by name or student ID...">
                                @if($filteredStudentId)
                                    <button wire:click="clearFilter" class="btn btn-outline-secondary">
                                        <i class="fas fa-times me-1"></i>Clear Filter
                                    </button>
                                @endif
                            </div>

                            @if($filteredStudentId && $selectedStudent)
                                <div class="mt-2 alert alert-info">
                                    <i class="fas fa-filter me-2"></i>Showing results for:
                                    <strong>{{ $selectedStudent->name }}</strong> ({{ $selectedStudent->student_id }})
                                </div>
                            @endif

                            @if($studentSearch && !$filteredStudentId)
                                @php
                                    $searchResults = $this->getStudentsForSearch();
                                @endphp

                                @if($searchResults->count() > 0)
                                    <div class="mt-2 border rounded" style="max-height: 200px; overflow-y: auto;">
                                        @foreach($searchResults as $student)
                                            <div class="p-2 border-bottom cursor-pointer hover-bg-light"
                                                 wire:click="selectStudent({{ $student->id }})"
                                                 style="cursor: pointer;"
                                                 onmouseover="this.style.backgroundColor='#f8f9fa'"
                                                 onmouseout="this.style.backgroundColor='white'">
                                                <strong>{{ $student->name }}</strong> ({{ $student->student_id }})
                                                @if($student->batch && $student->batch->schoolClass)
                                                    <br><small
                                                        class="text-muted">{{ $student->batch->schoolClass->display_name }}
                                                        - {{ $student->batch->name }}</small>
                                                @endif
                                            </div>
                                        @endforeach
                                    </div>
                                @endif
                            @endif
                        </div>

                        <div class="col-md-6 col-lg-4">
                            <label for="classSelect" class="form-label">Select Class</label>
                            <select wire:model.live="classId" id="classSelect" class="form-select">
                                <option value="">Choose Class...</option>
                                @foreach($classes as $class)
                                    <option value="{{ $class->id }}">{{ $class->display_name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-6 col-lg-4">
                            <label for="batchSelect" class="form-label">Select Batch</label>
                            <select wire:model.live="batchId" id="batchSelect" class="form-select"
                                    wire:key="batch-select-{{ $classId }}">
                                <option value="">Choose Batch...</option>
                                @foreach($batches as $batch)
                                    <option value="{{ $batch->id }}">{{ $batch->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-12 col-lg-4">
                            <label for="sessionSelect" class="form-label">Select Session</label>
                            <select wire:model.live="sessionId" id="sessionSelect" class="form-select">
                                <option value="">Choose Session...</option>
                                @foreach($sessions as $session)
                                    <option value="{{ $session->id }}">{{ $session->start_year }}
                                        /{{ $session->end_year }} - {{ $session->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="row mb-4">
                        <div class="col-12">
                            <button wire:click="loadStudents"
                                    class="btn btn-lg {{ !$classId || !$batchId || !$sessionId ? 'btn-secondary' : 'btn-primary' }} px-4 py-2"
                                    wire:loading.attr="disabled"
                                {{ !$classId || !$batchId || !$sessionId ? 'disabled' : '' }}>
                                <span wire:loading.remove wire:target="loadStudents">
                                    <i class="fas fa-search me-2"></i>Load Students
                                </span>
                                <span wire:loading wire:target="loadStudents">
                                    <i class="fas fa-spinner fa-spin me-2"></i>Loading...
                                </span>
                            </button>
                        </div>
                    </div>

                    @if($studentsData && count($studentsData) > 0)
                        <!-- Desktop Table -->
                        <div class="d-none d-md-block">
                            <div class="table-responsive">
                                <table class="table table-striped table-hover">
                                    <thead class="table-dark">
                                    <tr>
                                        <th>S/N</th>
                                        <th>Student Name</th>
                                        <th>Student ID</th>
                                        <th>Status</th>
                                        <th>Approved By</th>
                                        <th>Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($studentsData as $index => $data)
                                        <tr>
                                            <td>{{ $index + 1 }}</td>
                                            <td>{{ $data['student']->name }}</td>
                                            <td>{{ $data['student']->student_id ?? 'N/A' }}</td>
                                            <td>
                                                @if($data['status'] === 'Approved')
                                                    <span class="badge bg-success">{{ $data['status'] }}</span>
                                                @elseif($data['status'] === 'Pending')
                                                    <span class="badge bg-warning">{{ $data['status'] }}</span>
                                                @else
                                                    <span class="badge bg-danger">{{ $data['status'] }}</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($data['approved_by'])
                                                    <div>
                                                        <strong>{{ $data['approved_by'] }}</strong><br>
                                                        <small
                                                            class="text-muted">{{ $data['approved_at']->format('M d, Y') }}</small>
                                                    </div>
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($data['has_results'])
                                                    <button wire:click="viewStudentResult({{ $data['student']->id }})"
                                                            class="btn btn-sm btn-success me-1">
                                                        <i class="fas fa-eye me-1"></i>View
                                                    </button>
                                                    <a href="{{ route('results.print-student-result', ['student' => $data['student']->id, 'session' => $sessions->where('id', $sessionId)->first()->slug ?? '']) }}"
                                                       class="btn btn-sm btn-primary me-1"
                                                       onclick="window.open(this.href, 'printResult', 'width=794,height=1123,scrollbars=yes,resizable=yes'); return false;">
                                                        <i class="fas fa-print me-1"></i>Print
                                                    </a>
                                                    @if($data['is_approved'] && $this->canUnapprove())
                                                        <button
                                                            onclick="confirmUnapprove('{{ $data['student']->id }}', '{{ $data['student']->name }}')"
                                                            class="btn btn-sm btn-outline-danger">
                                                            <i class="fas fa-times me-1"></i>Unapprove
                                                        </button>
                                                    @endif
                                                @else
                                                    <span class="text-muted">No results available</span>
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <!-- Mobile Accordions -->
                        <div class="d-md-none">
                            @foreach($studentsData as $index => $data)
                                <div class="card mb-2">
                                    <div class="card-header p-0">
                                        <div class="d-flex">
                                            <div class="flex-grow-1 p-3" data-bs-toggle="collapse" data-bs-target="#student{{ $data['student']->id }}" style="cursor: pointer;">
                                                <div class="d-flex justify-content-between align-items-center">
                                                    <!-- Mobile view - show only name and number -->
                                                    <div>
                                                        <span class="badge bg-light text-dark me-2">{{ $index + 1 }}</span>
                                                        <strong>{{ $data['student']->name }}</strong>
                                                    </div>
                                                    
                                                    <!-- Mobile chevron -->
                                                    <div>
                                                        <i class="fas fa-chevron-down text-muted" style="transform: rotate(0deg); transition: transform 0.3s ease;"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="collapse" id="student{{ $data['student']->id }}">
                                        <div class="card-body">
                                            <div class="mb-3">
                                                <div class="d-flex flex-wrap gap-2 mb-2">
                                                    <span
                                                        class="badge bg-primary">ID: {{ $data['student']->student_id ?? 'N/A' }}</span>
                                                    <span
                                                        class="badge {{ $data['status'] === 'Approved' ? 'bg-success' : ($data['status'] === 'Pending' ? 'bg-warning' : 'bg-danger') }}">
                                                        {{ $data['status'] }}
                                                    </span>
                                                </div>
                                            </div>
                                            <p><strong>Student ID:</strong> {{ $data['student']->student_id ?? 'N/A' }}
                                            </p>
                                            <p><strong>Status:</strong>
                                                <span
                                                    class="badge {{ $data['status'] === 'Approved' ? 'bg-success' : ($data['status'] === 'Pending' ? 'bg-warning' : 'bg-danger') }}">
                                                        {{ $data['status'] }}
                                                    </span>
                                            </p>
                                            @if($data['approved_by'])
                                                <p><strong>Approved By:</strong> {{ $data['approved_by'] }}</p>
                                                <p><strong>Approved
                                                        On:</strong> {{ $data['approved_at']->format('M d, Y \a\t h:i A') }}
                                                </p>
                                            @endif
                                            @if($data['has_results'])
                                                <div class="d-flex flex-wrap gap-2">
                                                    <button wire:click="viewStudentResult({{ $data['student']->id }})"
                                                            class="btn btn-sm btn-success">
                                                        <i class="fas fa-eye me-1"></i>View
                                                    </button>
                                                    <a href="{{ route('results.print-student-result', ['student' => $data['student']->id, 'session' => $sessions->where('id', $sessionId)->first()->slug ?? '']) }}"
                                                       class="btn btn-sm btn-primary"
                                                       onclick="window.open(this.href, 'printResult', 'width=794,height=1123,scrollbars=yes,resizable=yes'); return false;">
                                                        <i class="fas fa-print me-1"></i>Print
                                                    </a>
                                                    @if($data['is_approved'] && $this->canUnapprove())
                                                        <button
                                                            onclick="confirmUnapprove('{{ $data['student']->id }}', '{{ $data['student']->name }}')"
                                                            class="btn btn-sm btn-outline-danger">
                                                            <i class="fas fa-times me-1"></i>Unapprove
                                                        </button>
                                                    @endif
                                                </div>
                                            @else
                                                <span class="text-muted">No results available</span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @elseif(is_array($studentsData) && count($studentsData) === 0)
                        <!-- No Approved Results Card -->
                        <div class="card border-warning">
                            <div class="card-body text-center py-5">
                                <i class="fas fa-exclamation-triangle fa-3x text-warning mb-3"></i>
                                @if($filteredStudentId && $selectedStudent)
                                    <h5 class="card-title text-warning">No Approved Results
                                        for {{ $selectedStudent->name }}</h5>
                                    <p class="card-text text-muted">
                                        <strong>{{ $selectedStudent->name }}</strong>
                                        ({{ $selectedStudent->student_id }}) does not have approved results for the
                                        selected session.
                                        <br>Results need to be approved before they can be viewed here.
                                    </p>
                                @else
                                    <h5 class="card-title text-warning">No Approved Results Found</h5>
                                    <p class="card-text text-muted">
                                        There are no approved results for the selected class, batch, and session.
                                        <br>Results need to be approved before they can be viewed here.
                                    </p>
                                @endif
                                <div class="mt-3">
                                    <a href="{{ route('results.approval') }}" class="btn btn-primary me-2">
                                        <i class="fas fa-check-circle me-1"></i>Go to Approve Results
                                    </a>
                                    <button wire:click="loadStudents" class="btn btn-outline-secondary">
                                        <i class="fas fa-refresh me-1"></i>Refresh
                                    </button>
                                </div>
                            </div>
                        </div>
                    @else
                        <div class="text-center py-5">
                            <i class="fas fa-users fa-3x text-muted mb-3"></i>
                            <p class="text-muted">Select class, batch, and session to view approved results</p>
                        </div>
                    @endif

                    @if($selectedStudentData)
                        <!-- Student Result Modal -->
                        <div class="modal fade show result-modal" style="display: block; background: rgba(0,0,0,0.5);"
                             tabindex="-1">
                            <div class="modal-dialog modal-xl modal-dialog-scrollable modal-fullscreen-md-down">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <span
                                            class="modal-title text-light">Result - {{ $selectedStudentData['student']->name }}</span>
                                        <button type="button" class="btn-close"
                                                wire:click="closeStudentResult"></button>
                                    </div>
                                    <div class="modal-body p-1 p-md-3">
                                        @include('results.partials.student-result-display-responsive', ['data' => $selectedStudentData, 'qrCode' => null])
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" wire:click="closeStudentResult">
                                            Close
                                        </button>
                                        <a href="{{ route('results.print-student-result', ['student' => $selectedStudentData['student']->id, 'session' => $selectedStudentData['session']->slug]) }}"
                                           class="btn btn-primary"
                                           onclick="window.open(this.href, 'printResult', 'width=794,height=1123,scrollbars=yes,resizable=yes'); return false;">
                                            <i class="fas fa-print me-1"></i>Print Result
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    function confirmUnapprove(studentId, studentName) {
        Swal.fire({
            title: 'Remove Approval?',
            text: `Are you sure you want to remove the approval for ${studentName}?`,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: 'var(--primary-color)',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Yes, Remove Approval',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                @this.call('unapproveResult', studentId);
            }
        });
    }
    
    document.addEventListener('shown.bs.collapse', function (e) {
        const chevron = e.target.previousElementSibling.querySelector('.fa-chevron-down');
        if (chevron) chevron.style.transform = 'rotate(180deg)';
    });
    
    document.addEventListener('hidden.bs.collapse', function (e) {
        const chevron = e.target.previousElementSibling.querySelector('.fa-chevron-down');
        if (chevron) chevron.style.transform = 'rotate(0deg)';
    });

</script>
